#!/bin/sh

macOS=false
current_dir="$(pwd -P)"

check_requirements() {
  case $(uname -s) in
    Darwin)
      printf "Installing on macOS"
      export CFLAGS='-stdlib=libc++'
      macOS=true
      ;;
    Linux)
      printf "Installing on Linux"
      ;;
    *)
      printf "Only Linux and macOS are currently supported.\n"
      exit 1
      ;;
  esac
}

install_python_packages() {
  printf "\nInstalling tensorflow...\n"
  if [ $macOS = "true" ]; then
    pip install tensorflow==2.5.0
  else
    conda install -c conda-forge cudatoolkit=11.2 cudnn=8.1 nccl -y
    pip install tensorflow==2.5.0
  fi
  printf "\nInstalling other Python packages...\n"
  pip install -r requirements.txt
}

set_python_path() {
  printf "\nSet conda environment variables...\n"
  conda env config vars set PYTHONPATH=$PYTHONPATH:$current_dir
}

check_requirements
install_python_packages
set_python_path

printf '\n\nSetup completed. Please restart conda environment\n'
