## Neuronal Learning Analysis using Cycle-Consistent Adversarial Network

### Table of content
- [1. Installation](#1-installation)
- [2. Dataset](#2-dataset)
- [3. Sort neurons](#3-sort-neruons)
- [4. Training model](#4-train-model)
- [5. Spike analysis](#5-spike-analysis)

## 1. Installation

### 1.1 Quick install
- Create a new [conda](https://conda.io/en/latest/) environment with Python 3.8
  ```
  conda create -n cyclegan python=3.8
  ```
- Activate `cyclegan` virtual environment
  ```
  conda activate cyclegan
  ```
- Install all dependencies and packages with `setup.sh` script, works on both Linus and macOS.
  ```
  sh setup.sh
  ```
- Restart environment
  ```
  conda deactivate
  conda activate cyclegan
  ```

### 1.2 Manual install
Install the following packages:
- [TensorFlow](https://tensorflow.org)
- [Neo](https://github.com/NeuralEnsemble/python-neo)
- [Elephant](https://github.com/NeuralEnsemble/elephant)
- packages in `requirements.txt`
- code from [Cascade](https://github.com/HelmchenLabSoftware/Cascade) are used in [cyclegan/utils/cascade](cyclegan/utils/cascade)

## 2. Dataset
- Place raw experimental data in `dataset/data/vr_data` and navigate to [dataset](dataset)
- We can generate `TFRecord` for mouse 1 data and store them at `dataset/tfreocrds/ST260/sl2048` with the following command
  ```
  python generate_vr_ds.py --input_x data/vr_data/ST260/ST260-AllVR1.mat --input_y data/vr_data/ST260/ST260-AllVR4.mat --output_dir tfrecords/ST260/sl2048 --sequence_length 2048 --train_size 3000 --val_size 200 --test_size 200 --scale_data
  ```

## 3. Sort neurons
- We have provided a script [scripts/sort_neurons.py](scripts/sort_neurons.py) to train an autoencoder which learns to reconstruct data from a particular experiment and use the reconstruction loss to order the neurons, OR sort by the average firing rate of each neuron.
- The following command train a CNN autoencoder on data recorded on day 1 and 4
  ```
  python sort_neurons.py --dataset ../dataset/tfrecords/ST260 --output_dir runs/ST260 --method autoencoder
  ```
- A json file `orders.json` will be saved in `scripts/runs/ST260/orders.json`, which store the neuron order based on the reconstruction loss.
- Use `--help` to see all available options.

## 4. Train model

- The `main.py` script contains the model training and logging procedures.
- Use `--help` flag to see all possible options.

### 4.1 Synthetic data
- To train a CycleGAN model using `LSGAN` objective with `AGResNet` architecture on the synthetic dataset, we can use the following command:
  ```
  python main.py --dataset dataset/tfrecords/ST260/sl2048 --output_dir runs/synthetic --algorithm lsgan --model agresnet --num_filters 32 --dropout 0.25 --patchgan --batch_size 1 --synthetic --epochs 200
  ```
- The model checkpoints and training logs are stored at `--output_dir`, in this case, `runs/synthetic`. 
- We can run TensorBoard to visualize the model training performance and plots:
  ```
  tensorboard --logdir runs/synthetic --port 6006
  ```
- Then visit `localhost:6006` on your browser

### 4.2 Recorded data
- To train a CycleGAN model using `LSGAN` objective with `AGResNet` on the mouse 1 recorded dataset, we can use the following command:
  ```
  python main.py --dataset dataset/tfrecords/ST260/sl2048 --output_dir runs/recorded --algorithm lsgan --model agresnet --num_filters 32 --dropout 0.25 --patchgan --batch_size 1 --epochs 200
  ```
- The model checkpoints and training logs are stored at `--output_dir`, in this case, `runs/recorded`. 
- To train the same model with neurons ordered by autoencoder reconstruction loss, we can use the following command:
  ```
  python main.py --dataset dataset/tfrecords/ST260/sl2048 --output_dir runs/ordered_recorded --algorithm lsgan --model agresnet --num_filters 32 --dropout 0.25 --patchgan --neuron_order_json scripts/runs/ST260/order.json --batch_size 1 --epochs 200
  ```

## 5. Spike analysis
- After training the model, a `signals.h5` file is saved in `--output_dir/samples`, which consists of all generated calcium traces from the last epoch.
- To evaluate the model trained on recorded data with checkpoints saved at `runs/recorded`, we first apply [Cascade](https://www.nature.com/articles/s41593-021-00895-5) to infer spike trains from the calcium imaging signals.
  ```
  python analysis.py --output_dir runs/recorded
  ```
- The command above store the inferred spike trains to `--output_dir/samples/spikes.h5`, we can then run the spike analysis with the same command:
  ```
  python analysis.py --output_dir runs/recorded
  ```
- We can then run `tensorboard --logdir runs/recorded` to inspect the results.
- Use `--help` to see all available options.