import numpy as np
import pandas as pd

num_samples = int(1e3)
dimension = 10
X = np.random.uniform(-1, 1, size=(num_samples, dimension))

theta = np.random.uniform(-2, 2, size=(dimension,))
theta = np.random.norm(0, 1, size=(dimension,))
b = np.random.norm(0,1)

y = np.sign(np.dot(X, theta) + b)
data = pd.DataFrame(np.column_stack((X, y)), columns=[f'x_{i}' for i in range(dimension)] + ['y'])
data.to_csv('data.csv', index=False)
