import torch
import argparse
from models.psp import pSp
from models.psp_swagan import pSp as pSp_swagan

def setup_model(checkpoint_path, device='cuda', is_swagan=True):
    ckpt = torch.load(checkpoint_path, map_location='cpu')
    opts = ckpt['opts']

    is_cars = 'car' in opts['dataset_type']
    is_faces = 'ffhq' in opts['dataset_type']
    if is_faces:
        opts['stylegan_size'] = 1024
    elif is_cars:
        opts['stylegan_size'] = 512
    else:
        opts['stylegan_size'] = 256

    opts['checkpoint_path'] = checkpoint_path
    opts['device'] = device
    opts['is_train'] = False
    opts = argparse.Namespace(**opts)

    if is_swagan:
        net = pSp_swagan(opts)
    else:
        net = pSp(opts)
    net.eval()
    net = net.to(device)
    return net, opts
