from PIL import Image
import matplotlib.pyplot as plt


# Log images
def log_input_image(x, opts):
	return tensor2im(x)


def tensor2im(var):
	# var shape: (3, H, W)
	var = var.cpu().detach().transpose(0, 2).transpose(0, 1).numpy()
	var = ((var + 1) / 2)
	var[var < 0] = 0
	var[var > 1] = 1
	var = var * 255
	return Image.fromarray(var.astype('uint8'))


def vis_faces(log_hooks, num_im=3):
	display_count = len(log_hooks)
	fig = plt.figure(figsize=(16, 4 * display_count))
	gs = fig.add_gridspec(display_count, num_im)
	for i in range(display_count):
		hooks_dict = log_hooks[i]
		fig.add_subplot(gs[i, 0])
		if 'diff_input' in hooks_dict:
			vis_faces_with_id(hooks_dict, fig, gs, i, num_im)
		else :
			vis_faces_no_id(hooks_dict, fig, gs, i, num_im)
		
	plt.tight_layout()
	return fig


def vis_faces_with_id(hooks_dict, fig, gs, i, num_im):
	plt.imshow(hooks_dict['input_face'])
	plt.title('Input\nOut Sim={:.2f}'.format(float(hooks_dict['diff_input'])))
	fig.add_subplot(gs[i, 1])
	plt.imshow(hooks_dict['target_face'])
	plt.title('Inversion\nIn={:.2f}, Out={:.2f}'.format(float(hooks_dict['diff_views']),
	                                                 float(hooks_dict['diff_target'])))
	fig.add_subplot(gs[i, 2])
	plt.imshow(hooks_dict['output_face'])
	plt.title('Output\n Inversion Sim={:.2f}'.format(float(hooks_dict['diff_target'])))

	if num_im>3:
		fig.add_subplot(gs[i, 3])
		plt.imshow(hooks_dict['res_aligned'])
		plt.title('ResAligned\n loss={:.2f}'.format(float(hooks_dict['loss_res'])))
		fig.add_subplot(gs[i, 4])
		plt.imshow(hooks_dict['fused'])
		plt.title('Fusion\n loss={:.2f}'.format(float(hooks_dict['loss_fusion'])))


def vis_faces_no_id(hooks_dict, fig, gs, i, num_im):
	plt.imshow(hooks_dict['input_face'], cmap="gray")
	plt.title('Input')
	fig.add_subplot(gs[i, 1])
	plt.imshow(hooks_dict['target_face'])
	plt.title('Inversion')
	fig.add_subplot(gs[i, 2])
	plt.imshow(hooks_dict['output_face'])
	plt.title('Output')

	if num_im>3:
		fig.add_subplot(gs[i, 3])
		plt.imshow(hooks_dict['res_aligned'])
		plt.title('ResAligned')
		fig.add_subplot(gs[i, 4])
		plt.imshow(hooks_dict['fused'])
		plt.title('Fusion')


from typing import Tuple, List
import numpy as np

def make_transform(translate: Tuple[float, float], angle: float):
    m = np.eye(3)
    s = np.sin(angle / 360.0 * np.pi * 2)
    c = np.cos(angle / 360.0 * np.pi * 2)
    m[0][0] = c
    m[0][1] = s
    m[0][2] = translate[0]
    m[1][0] = -s
    m[1][1] = c
    m[1][2] = translate[1]
    return m

def get_identity_transform():
    translate = (0, 0)
    rotate = 0.
    m = make_transform(translate, rotate)
    m = np.linalg.inv(m)
    return m