# Learning to Reconstruct Missing Data from Spatiotemporal Graphs with Sparse Observations

---

In this file, we provide some instructions for the reproducibility of the experiments presented in the paper "Learning to Reconstruct Missing Data from Spatiotemporal Graphs with Sparse Observations".

## Directory structure

The directory is structured as follows:

```
.
├── config/
│   ├── imputation/
│   │   ├── brits.yaml
│   │   ├── grin.yaml
│   │   ├── saits.yaml
│   │   ├── spin.yaml
│   │   ├── spin_h.yaml
│   │   └── transformer.yaml
│   └── inference.yaml
├── experiments/
│   ├── run_imputation.py
│   └── run_inference.py
├── spin/
│   ├── baselines/
│   ├── imputers/
│   ├── layers/
│   ├── models/
│   └── ...
├── conda_env.yaml
└── tsl_config.yaml

```

## Installation

We provide a conda environment with all the project dependencies. To install the environment use:

```bash
conda env create -f conda_env.yml
conda activate spin
```

## Configuration files

The `config/` directory stores all the configuration files used to run the experiment. `config/imputation/` stores model configurations used for experiments on imputation.

## Python package `spin`

The support code, including models and baselines, are packed in a python package named `spin`.

## Experiments

The scripts used for the experiment in the paper are in the `experiments` folder.

* `run_imputation.py` is used to compute the metrics for the deep imputation methods. An example of usage is

	```bash
	conda activate spin
	python ./experiments/run_imputation.py --config imputation/spin.yaml --model-name spin --dataset-name bay_block
	```

* `run_inference.py` is used for the experiments on sparse datasets using pre-trained models. An example of usage is

	```bash
	conda activate spin
	python ./experiments/run_inference.py --config inference.yaml --model-name spin --dataset-name bay_point --exp-name {exp_name}
	```
 