# GT-test 
This repo is the official implementation of "On Structural Expressive Power of Graph Transformers". 


## Introduction

<p align="center">
  <img src="docs/GTtest.PNG" width="600" align="left"> 
</p>

GT-test with various structural encodings is a unified framework proposed by us for analyzing the expressive power of graph Transformers.

It has been proved that GT-test with SPD or SPIS is strictly more powerful than WL-test on distinguishing non-isomorphic graph pairs. The source code for experiments of synthetic isomorphism tests can be found here.

## Requirements and Installation

#### Setup with Conda
```
# create new conda environment
conda create --name GT_test python=3.7
conda activate GT_test

# install requirements
pip install networkx==2.2 matplotlib==2.2.5
```

## Example Usage
To enumerate and search for non-isomorphic graph pairs which can not be distinguished by WL-test or GT-test with certain structural encoding over a certain number of nodes, just run `WLtest_enumerate_pairs.py` or `GTtest_enumerate_pairs.py`. Note that the number of nodes(`num_nodes`, from 2 to 8) and iterations(`I`) and the type of structural encoding utilized in GT-test(`RSE`, SPD or SPIS) should be set in the code by yourself before running.

To enumerate and search for non-isomorphic graph pairs which can be distinguished by WL-test or GT-test with certain structural encoding over the group of strongly regular graphs with a certain four-parameter combination, just run `srg_enumerate.py`. Note that the number of file(`file_num`, from 1 to 6) and iterations(`I`) and the type of test(`test_name`, WL or GT;`RSE`, SPD or SPIS) should be set in the code by yourself before running.

After downloading the data files provided with our source code, the graphs will be read in and processed automatically. During searching process, found pairs will be saved in the `/output` directory as figures drawn by networkx.
