#!/usr/bin/env bash
ADDR=$1
MASTER_ADDR=$1
MASTER_PORT=12345
CUDA_VISIBLE_DEVICES=0 python -m torch.distributed.launch \
--nproc_per_node=1 \
--nnodes=1 \
--master_addr=$MASTER_ADDR \
--master_port=$MASTER_PORT \
./train.py \
--model=resnet18 \
--dataset=flower102 \
--data=../data/flower102 \
--optimizer=LBFGS \
--update-freq=30 \
--stat-decay-param=0.9 \
--stat-decay-grad=0.9 \
--history-size=20 \
--lbfgs-damping=0.01 \
--grad-clip=0.01 \
--max-epoch=150 \
--lr=0.1 \
--wd=0.0005 \
--momentum=0.9 \
--workers=4 \
--logdir=log/flower102/lr/warmup/resnet18/LBFGS/lr0.1-0.5_b256_wd5e-4_m0.9_mm0.9_damp0.01_clip0.01-initlr_ylr_noh0 \
--init-bn0 \
--phases "[{'ep': 0, 'sz': 224, 'bs': 256},
{'ep': (0, 5), 'lr': (0.1, 0.5)},
{'ep': (5, 50), 'lr': (0.5, 0.5)},
{'ep': (50, 100), 'lr': (0.05, 0.05)},
{'ep': (100, 150), 'lr': (0.005, 0.005)}]" \
--skip-auto-shutdown


