#!/usr/bin/env bash
NPROC_PER_NODE=$1
NNODE=$2
NODE_RANK=$3
MASTER_ADDR=$4
MASTER_PORT=$5
SINGLE_NODE=true

# single node: ResNet on ImageNet
MASTER_ADDR=$2
MASTER_PORT=$3
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python -m torch.distributed.launch \
--nproc_per_node=$NPROC_PER_NODE \
--master_addr=$MASTER_ADDR \
--master_port=$MASTER_PORT \
./train_lambda.py \
--model=resnet50 \
--dataset=imagenet \
--data=~/dataset/cv/imagenet/ \
--optimizer=LBFGS \
--update-freq=200 \
--stat-decay-param=0.9 \
--stat-decay-grad=0.9 \
--history-size=20 \
--lbfgs-damping=0.005 \
--grad-clip=0.01 \
--max-epoch=100 \
--lr=0.1 \
--decay-period=10 \
--wd=0.0001 \
--momentum=0.9 \
--workers=4 \
--logdir=log/imagenet/lr_standard/LBFGS/lr0.1_b512_wd5_m0.9_mm0.9_damp0.005_clip0.01_ylr_noh0_fp16 \
--fp16 \
--init-bn0 \
--distributed \
--phases "[{'ep': 0, 'sz': 224, 'bs': 64},
{'ep': (0, 30), 'lr': (0.1, 0.1)},
{'ep': (30, 60), 'lr': (0.01, 0.01)},
{'ep': (60, 90), 'lr': (0.001, 0.001)},
{'ep': (90, 100), 'lr': (0.0001, 0.0001)}]" \
--skip-auto-shutdown

