#!/usr/bin/env bash
NPROC_PER_NODE=$1
NNODE=$2
NODE_RANK=$3
MASTER_ADDR=$4
MASTER_PORT=$5

MASTER_ADDR=$2
MASTER_PORT=$3
CUDA_VISIBLE_DEVICES=1 python -m torch.distributed.launch \
    --nproc_per_node=$NPROC_PER_NODE \
    --master_addr=$MASTER_ADDR \
    --master_port=$MASTER_PORT \
    ./train.py \
    --model=resnet18 \
    --dataset=cifar10 \
    --data=./data/cifar10 \
    --optimizer=SLIM \
    --update-freq=50 \
    --stat-decay-param=0.0 \
    --stat-decay-grad=0.0 \
    --history-size=10 \
    --lbfgs-damping=0.0 \
    --grad-clip=0.0 \
    --max-epoch=100 \
    --lr=0.1 \
    --wd=0.0005 \
    --momentum=0.9 \
    --workers=4 \
    --logdir=log/ICLR/cifar10/LBFGS/resnet18/lr0.1-step_b64_wd5e-4_u50_h10 \
    --init-bn0 \
    --phases "[{'ep': 0, 'sz': 32, 'bs': 64},
    {'ep': (0, 100), 'lr': (0.1, 0.001)}]" \
    --skip-auto-shutdown