#!/usr/bin/env bash
NPROC_PER_NODE=$1
NNODE=$2
NODE_RANK=$3
MASTER_ADDR=$4
MASTER_PORT=$5

MASTER_ADDR=$2
MASTER_PORT=$3
CUDA_VISIBLE_DEVICES=1 python -m torch.distributed.launch \
    --nproc_per_node=$NPROC_PER_NODE \
    --master_addr=$MASTER_ADDR \
    --master_port=$MASTER_PORT \
    ./train.py \
    --model=resnet18 \
    --dataset=cifar10 \
    --data=./data/cifar10 \
    --optimizer=SLIM \
    --update-freq=50 \
    --stat-decay-param=0.9 \
    --stat-decay-grad=0.9 \
    --history-size=10 \
    --lbfgs-damping=0.05 \
    --grad-clip=1 \
    --max-epoch=225 \
    --lr=0.1 \
    --wd=0.0005 \
    --momentum=0.9 \
    --workers=4 \
    --logdir=log/ICLR/cifar10/SLIM/resnet18/lr0.1warm-step_b256_wd5e-4_mm0.9_u50_h10_d0.05 \
    --init-bn0 \
    --phases "[{'ep': 0, 'sz': 32, 'bs': 256},
    {'ep': (0, 5), 'lr': (0.02, 0.2)},
    {'ep': (5, 150), 'lr': (0.2, 0.2)},
    {'ep': (150, 225), 'lr': (0.02, 0.02)}]" \
    --skip-auto-shutdown