#!/usr/bin/env bash
NPROC_PER_NODE=$1
NNODE=$2
NODE_RANK=$3
MASTER_ADDR=$4
MASTER_PORT=$5
SINGLE_NODE=true

# single node: ResNet on ImageNet
MASTER_ADDR=$2
MASTER_PORT=$3
CUDA_VISIBLE_DEVICES=4,5,6,7 python -m torch.distributed.launch \
--nproc_per_node=$NPROC_PER_NODE \
--master_addr=$MASTER_ADDR \
--master_port=$MASTER_PORT \
./train.py  \
--model=resnet50 \
--dataset=imagenet \
--data=~/dataset/ \
--optimizer=SGD \
--max-epoch=100 \
--lr=0.1 \
--decay-period=10 \
--wd=0.0005 \
--momentum=0.9 \
--workers=8 \
--logdir=log/ICLR/imagenet/SGD/resnet50/lr0.1warm-step_b256_wd5e-4_m0.9_run1\
--init-bn0 \
--distributed \
--phases "[{'ep': 0, 'sz': 224, 'bs': 64},
{'ep': (0, 2), 'lr': (0.01, 0.4)},
{'ep': (2, 30), 'lr': (0.4, 0.4)},
{'ep': (30, 60), 'lr': (0.04, 0.04)},
{'ep': (60, 90), 'lr': (0.004, 0.004)},
{'ep': (90, 100), 'lr': (0.0004, 0.0004)}]" \
--skip-auto-shutdown



