# DeepSAT

Code repository for the paper: **DeepSAT: An EDA-Driven Learning Framework for SAT**

## Introduction
We present DeepSAT, a novel end-to-end learning framework for the Boolean satisfiability (SAT) problem. Unlike existing solutions trained on random SAT instances with relatively weak supervision, we propose applying the knowledge of the well-developed electronic design automation (EDA) field for SAT solving. Specifically, we first resort to advanced logic synthesis algorithms to pre-process SAT instances into optimized and-inverter graphs (AIGs). By doing so, the distribution diversity among different SAT instances can be reduced, which facilitates the learned model to generalize well across various sources of SAT instances. Next, we regard the distribution of SAT solutions being a product of conditional Bernoulli distributions. Based on this observation, we approximate the SAT solving procedure with a conditional generative model, leveraging a directed acyclic graph neural network with two polarity prototypes for conditional SAT modeling. To effectively train the generative model, with the help of logic simulation tools, we obtain the probabilities of nodes in the AIG being logic ‘1’ as rich supervision. We conduct extensive experiments on various SAT instances. DeepSAT achieves significant accuracy improvements over state-of-the-art learning-based SAT solutions, especially when generalized to SAT instances that are large or with diverse distributions.

## Models
In this repo, we build a comprehensive and practical codebase like [timm](https://github.com/rwightman/pytorch-image-models) to compare the various end-to-end SAT solvers fairly. This repo is still ongoing and only for ICLR review. Until now, the repo supports the following end-to-end solvers: 

1. **DeepSAT**
2. NeuroSAT
3. DG-DAGRNN
4. *TBD*

## Training examples

### Prepare Training dataset
We provide an example dataset in `./data/random_sr3_10_100`, please parse the dataset on cpu. 
```bash
python parse_dataset.py --type gate --path ./data/random_sr3_10_100 # For DeepSAT
python parse_dataset.py --type cnf --path ./data/random_sr3_10_100  # For NeuroSAT
python parse_dataset.py --type ckt --path ./data/random_sr3_10_100  # For DG-DAGRNN
```

### DeepSAT
```bash
# training on raw aig
sh distributed_train.sh 4 data/random_sr3_10_10000 --dataset gate --model deepsat -b 128 --sched step --epochs 60 --decay-milestones 30 45 --decay-rate .1 --opt adam -j 8 --weight-decay 1e-4 --warmup-epochs 0 --amp --lr .0001 --l1-loss --experiment deepsat_sr3_10_rawaig
# traininig on opt aig
sh distributed_train.sh 4 data/random_sr3_10_10000 --dataset gate --model deepsat -b 128 --sched step --epochs 60 --decay-milestones 30 45 --decay-rate .1 --opt adam -j 8 --weight-decay 1e-4 --warmup-epochs 0 --amp --lr .0001 --l1-loss --experiment deepsat_sr3_10_optaig --aig-opt
# validation
python validate.py data/random_sr10_10_100 --dataset gate --model deepsat --checkpoint output/train/dgdagrnn_sr_3_10/model_best.pth.tar
```

### DGDAGRNN
```bash
# training on flat circuit
sh distributed_train.sh 4 data/random_sr3_10_10000 --dataset ckt --model dgdagrnn -b 128 --sched step --epochs 60 --decay-milestones 30 45 --opt adam -j 8  --weight-decay 1e-10 --warmup-epochs 0 --amp --lr 1e-5 --clip-grad 0.65 --smooth-step-loss --experiment dgdagrnn_sr3_10_ckt
# training on raw aig
sh distributed_train.sh 4 data/random_sr3_10_10000 --dataset ckt --model dgdagrnn -b 128 --sched step --epochs 60 --decay-milestones 30 45 --opt adam -j 8  --weight-decay 1e-10 --warmup-epochs 0 --amp --lr 1e-5 --clip-grad 0.65 --smooth-step-loss --experiment dgdagrnn_sr3_10_rawaig --use-aig
# training on opt aig
sh distributed_train.sh 4 data/random_sr3_10_10000 --dataset ckt --model dgdagrnn -b 128 --sched step --epochs 60 --decay-milestones 30 45 --opt adam -j 8  --weight-decay 1e-10 --warmup-epochs 0 --amp --lr 1e-5 --clip-grad 0.65 --smooth-step-loss --experiment dgdagrnn_sr3_10_optaig --use-aig --aig-opt

# validation
python validate.py data/random_sr10_10_100 --dataset ckt --model dgdagrnn --checkpoint output/train/dgdagrnn_sr_3_10/model_best.pth.tar
```

## Note
1. The current circuit parsing (PyG pre-processing) does not support multi-gpu, since multi-processing will generate `data.pt` at the same time and thus cause conflict.
2. Validation (SAT solving) does not support multi-gpu settings.

