import hydra
from hydra.utils import instantiate
from omegaconf import OmegaConf

from src.runner import run_experiments
from src.types import APIModel, ExperimentConfig


@hydra.main(version_base=None, config_path="config/examples", config_name="local")
def main(cfg: ExperimentConfig):
    print(OmegaConf.to_yaml(cfg))

    if hasattr(cfg, "override_model_seed") and cfg.override_model_seed:
        models = [instantiate(m, model_seed=cfg.model_seed) for m in cfg.models]
    else:
        models = [instantiate(m) for m in cfg.models]

    cfg = instantiate(cfg)
    cfg.models = models 
    
    for model in cfg.models:
        if isinstance(model, APIModel):
            assert cfg.confirm_include_api_models, "Need `confirm_include_api_models=True` to approve using API models. This prevents unwanted costs."

    run_experiments(cfg)


if __name__ == "__main__":
    main()
