#include <bits/stdc++.h>
#include <x86intrin.h>
#include "lognum.hpp"

#include <boost/multiprecision/cpp_int.hpp>
#include <boost/multiprecision/cpp_dec_float.hpp>
#include <boost/random/mersenne_twister.hpp>
#include <boost/random/uniform_int_distribution.hpp>

#define Num LogNum /*boost::multiprecision::int512_t*/
#define FloatNum boost::multiprecision::number<boost::multiprecision::cpp_dec_float<100>>

using namespace std;

vector<Num*> local_scores;
vector<Num*> zeta;
Num* g;
Num* forward_weights;
int n;
map<int, string> node_names;

mt19937 gen;
boost::random::mt19937 boost_gen;

chrono::steady_clock::time_point start_time;

long double time_since(chrono::steady_clock::time_point start) {
	return std::chrono::duration_cast<std::chrono::milliseconds>(chrono::steady_clock::now() - start).count() / 1000.;
}

inline int reduce(int s, int mask) { // take bits of indicated by mask and shift them to be the least significant bits 
    return _pext_u64(s, mask);
}

inline int expand(int s, int mask) { // move the least significant bits of s to the indices indicated by the mask
    return _pdep_u64(s, mask);
}

void zeta_transform(Num* target, Num* f, int l) {
    Num f_hat[l + 1][1<<l];
    for (int x = 0; x < (1<<l); x++) {
        f_hat[0][x] = f[x];
    }
    for (int j = 1; j <= l; j++) {
        for (int x = 0; x < (1<<l); x++) {
            if (x & (1<<(j - 1))) {
                f_hat[j][x] = f_hat[j - 1][x ^ (1<<(j - 1))] + f_hat[j - 1][x];
            } else {
                f_hat[j][x] = f_hat[j - 1][x];
            }
        }
    }
    for (int x = 0; x < (1<<l); x++) {
        target[x] = f_hat[l][x];
    }
}

void mobius_inverse(Num* target, Num* f, int l) {
    for (int s = 0; s < (1<<l); s++) {
        if (__builtin_popcount(s) & 1) {
            f[s] *= -1;
        }
    }
    zeta_transform(target, f, l);
    for (int s = 0; s < (1<<l); s++) {
        if (__builtin_popcount(s) & 1) {
            f[s] *= -1;
            target[s] *= -1;
        }
    }
}

void ranked_zeta_transform(Num* target, Num* f, int l, int k) {
    Num f_hat[l + 1][1<<l];
    for (int x = 0; x < (1<<l); x++) {
        if (__builtin_popcount(x) == k) {
            f_hat[0][x] = f[x];
        } else {
            f_hat[0][x] = 0;
        }
    }
    for (int j = 1; j <= l; j++) {
        for (int x = 0; x < (1<<l); x++) {
            if (x & (1<<(j - 1))) {
                f_hat[j][x] = f_hat[j - 1][x ^ (1<<(j - 1))] + f_hat[j - 1][x];
            } else {
                f_hat[j][x] = f_hat[j - 1][x];
            }
        }
    }
    for (int x = 0; x < (1<<l); x++) {
        target[x] = f_hat[l][x];
    }
}

void read_input(string src) {
    ifstream fin(src);
    fin>>n;
    for (int i = 0; i < n; i++) {
        local_scores.push_back(new Num[1<<n]);
        zeta.push_back(new Num[1<<n]);
        for (int j = 0; j < (1<<n); j++) {
            local_scores[i][j] = 0;
        }
    }
    unordered_map<string, int> um;
    for (int i = 0; i < n; i++) {
        int v, p;
        string s;
        fin>>s>>p;
        if (um.find(s) == um.end()) {
            node_names[um.size()] = s;
            um[s] = um.size();
        }
        v = um[s];
        for (int j = 0; j < p; j++) {
            long double score;
            int c;
            int mask = 0;
            fin>>score>>c;
            for (int k = 0; k < c; k++) {
                string l;
                fin>>l;
                if (um.find(l) == um.end()) {
                    node_names[um.size()] = l;
                    um[l] = um.size();
                }
                mask ^= (1<<um[l]);
            }
            local_scores[v][mask].set_log(score);
        }
    }
    fin.close();
}

Num potential_parents_weight(int v, int r, int t) {
    return zeta[v][t] - zeta[v][t ^ r];
}

void compute_cumulative() {
    for (int i = 0; i < n; i++) {
        zeta_transform(zeta[i], local_scores[i], n);
    }
}

void compute_subgraphs() {
    g = new Num[1<<n];
    g[0] = 1;
    for (int u = 1; u < (1<<n); u++) {
        g[u] = 0;
        for (int r = u; r > 0; r = (r - 1) & u) {
            Num sink_w;
            sink_w = 1;
            for (int v = 0; v < n; v++) {
                if (r & (1<<v)) {
                    sink_w *= zeta[v][((1<<n) - 1) ^ u];
                }
            }
            if (__builtin_popcount(r) % 2 == 0) {
                sink_w = -sink_w;
            }
            g[u] += g[u ^ r] * sink_w;
        }
    }
}

void compute_forward_weights(int u) {
    int l = __builtin_popcount(u);
    for (int i = 0; i < (1<<l); i++) {
        forward_weights[i] = g[expand(i, u)];
    }
    for (int vi = 0; vi < l; vi++) {
        Num weight = -zeta[ __builtin_ctz(expand(1<<vi, u))][((1<<n) - 1) ^ u];
        for (int i = (1<<vi); i < (1<<l); i += (2<<vi)) {
            for (int j = i; j < i + (1<<vi); j++) {
                forward_weights[j] += forward_weights[j - (1<<vi)] * weight;
            }
        }
    }
    reverse(forward_weights, forward_weights + (1<<l));
}

Num uniform_random(Num ub) {
    uniform_real_distribution<> uniform_dist(0, 1);
    return uniform_dist(gen) * ub;
}

int weighted_sample(Num* arr, int l) {
    Num sum;
    sum = 0;
    for (int i = 0; i < l; i++) {
        sum += arr[i];
    }
    Num pos = uniform_random(sum);
    for (int index = 0; index < l; index++) {
        pos -= arr[index];
        if (pos < 0) {
            return index;
        }
    }
    return -1;
}

int sample_parents(int v, int r, int t) {
    if (!r) return 0;
    int l = __builtin_popcount(t);
    Num pr[1<<l];
    for (int i = 0; i < (1<<l); i++) {
        if (expand(i, t) & r) {
            pr[i] = local_scores[v][expand(i, t)];
        } else {
            pr[i] = 0;
        }
    }
    return expand(weighted_sample(pr, 1<<l), t);
}

vector<pair<int, int>> sample() {
    vector<pair<int, int>> graph;
    int forward = (1<<n) - 1;
    int previous = 0;
    while (forward) {
        int f_count = __builtin_popcount(forward);
        Num weights[1<<f_count];
        weights[0] = 0;
        compute_forward_weights(forward);
        for (int index = 1; index < (1<<f_count); index++) {
            int r = expand(index, forward);
            weights[index] = forward_weights[index];
            for (int v = 0; v < n; v++) {
                if (r & (1<<v)) {
                    if (previous) {
                        weights[index] *= potential_parents_weight(v, previous, ((1<<n) - 1) ^ forward);
                    } else {
                        weights[index] *= local_scores[v][0];
                    }
                }
            }
        }
        int layer = expand(weighted_sample(weights, 1<<f_count), forward);
        for (int v = 0; v < n; v++) {
            if (layer & (1<<v)) {
                int parents = sample_parents(v, previous, ((1<<n) - 1) ^ forward);
                for (int j = 0; j < n; j++) {
                    if (parents & (1<<j)) {
                        graph.push_back({j, v});
                    }
                }
            }
        }
        forward ^= layer;
        previous = layer;
    }
    return graph;
}

void preprocess() {
    forward_weights = new Num[1<<n];
    compute_cumulative();
    compute_subgraphs();
}

int main(int argc, char *argv[]) {
    boost_gen.seed(time(0));
	gen.seed(time(0));

	start_time = chrono::steady_clock::now();

    read_input(string(argv[1]));
    preprocess();

    long double preprocessing_time = time_since(start_time);

    int K = 10000;
    for (int i = 0; i < K; i++) {
        auto graph = sample();
        Num score;
        score = 1;
        for (int i = 0; i < n; i++) {
            int mask = 0;
            for (pair<int, int> p : graph) {
                if (p.second == i) {
                    mask += 1<<p.first;
                }
            }
            score *= local_scores[i][mask];
        }
        cout<<score<<" ";
        for (int i = 0; i < n; i++) {
            if (i) cout<<" ";
            cout<<node_names[i]<<"<-";
            bool first = true;
            for (pair<int, int> p : graph) {
                if (p.second == i) {
                    if (!first) cout<<",";
                    cout<<node_names[p.first];
                    first = false;
                }
            }
        }
        cout<<endl;
    }


    long double sampling_time = time_since(start_time) - preprocessing_time;
    long double average_time = sampling_time / K;
    
    cerr<<"Preprocessing:  "<<preprocessing_time<<"s"<<endl;
    cerr<<"Sampling:       "<<sampling_time<<"s"<<endl;
    cerr<<"Per sample:     "<<average_time<<"s"<<endl;
}