# Faster Perfect Sampling of Bayesian Network Structures

The supplementary material contains the C++ implementations of the samplers.

For larger graphs, it may be necessary to increase stack size with
```
ulimit -s unlimited
```

## Compiling

The implementations were compiled with

```
g++ [source_file] -march=native -O2 -o [output_name]
```

## Randomized graphs

The files `reject_random.cpp` and `talvitie_random.cpp` contain the implementations of the samplers for synthetic inputs. Modify the `generate_input()` function to change how the input is generated.

Now, the programs take `n` from standard input and give a random local score from `{0, 1}` for each parent set. After 100 successful samples, time usage and edge posterior probabilities are outputted.

## Benchmark graphs

The files `reject_input.cpp` and `talvitie_input.cpp` contain the implementations of the samplers for instances with a score file. Give the file name of the score file as an argument to the program, e.g.,

```
./reject_input asia-1000.jkl
```

The programs sample currently `10000` DAGs and output their scores and edges.
