#include <bits/stdc++.h>
#include <x86intrin.h>
#include "lognum.hpp"

#include <boost/multiprecision/cpp_int.hpp>
#include <boost/multiprecision/cpp_dec_float.hpp>
#include <boost/random/mersenne_twister.hpp>
#include <boost/random/uniform_int_distribution.hpp>

#define Num LogNum /*boost::multiprecision::int512_t*/
#define FloatNum boost::multiprecision::number<boost::multiprecision::cpp_dec_float<100>>

using namespace std;

vector<Num*> local_scores;
vector<Num*> zeta;
Num* h;
Num* g;
Num* forward_weights;
Num* backward_weights;
int n;
map<int, string> node_names;

mt19937 gen;

boost::random::mt19937 boost_gen;

chrono::steady_clock::time_point start_time;

long double time_since(chrono::steady_clock::time_point start) {
	return std::chrono::duration_cast<std::chrono::milliseconds>(chrono::steady_clock::now() - start).count() / 1000.;
}

inline int reduce(int s, int mask) { // take bits of s indicated by mask and shift them to be the least significant bits 
    return _pext_u64(s, mask);
}

inline int expand(int s, int mask) { // move the least significant bits of s to the indices indicated by the mask
    return _pdep_u64(s, mask);
}

void zeta_transform(Num* target, Num* f, int l) {
    Num f_hat[l + 1][1<<l];
    for (int x = 0; x < (1<<l); x++) {
        f_hat[0][x] = f[x];
    }
    for (int j = 1; j <= l; j++) {
        for (int x = 0; x < (1<<l); x++) {
            if (x & (1<<(j - 1))) {
                f_hat[j][x] = f_hat[j - 1][x ^ (1<<(j - 1))] + f_hat[j - 1][x];
            } else {
                f_hat[j][x] = f_hat[j - 1][x];
            }
        }
    }
    for (int x = 0; x < (1<<l); x++) {
        target[x] = f_hat[l][x];
    }
}

void mobius_inverse(Num* target, Num* f, int l) {
    for (int s = 0; s < (1<<l); s++) {
        if (__builtin_popcount(s) & 1) {
            f[s] *= -1;
        }
    }
    zeta_transform(target, f, l);
    for (int s = 0; s < (1<<l); s++) {
        if (__builtin_popcount(s) & 1) {
            f[s] *= -1;
            target[s] *= -1;
        }
    }
}

void ranked_zeta_transform(Num* target, Num* f, int l, int k) {
    Num f_hat[l + 1][1<<l];
    for (int x = 0; x < (1<<l); x++) {
        if (__builtin_popcount(x) == k) {
            f_hat[0][x] = f[x];
        } else {
            f_hat[0][x] = 0;
        }
    }
    for (int j = 1; j <= l; j++) {
        for (int x = 0; x < (1<<l); x++) {
            if (x & (1<<(j - 1))) {
                f_hat[j][x] = f_hat[j - 1][x ^ (1<<(j - 1))] + f_hat[j - 1][x];
            } else {
                f_hat[j][x] = f_hat[j - 1][x];
            }
        }
    }
    for (int x = 0; x < (1<<l); x++) {
        target[x] = f_hat[l][x];
    }
}

void read_input(string src) {
    ifstream fin(src);
    fin>>n;
    for (int i = 0; i < n; i++) {
        local_scores.push_back(new Num[1<<n]);
        zeta.push_back(new Num[1<<n]);
        for (int j = 0; j < (1<<n); j++) {
            local_scores[i][j] = 0;
        }
    }
    unordered_map<string, int> um;
    for (int i = 0; i < n; i++) {
        int v, p;
        string s;
        fin>>s>>p;
        if (um.find(s) == um.end()) {
            node_names[um.size()] = s;
            um[s] = um.size();
        }
        v = um[s];
        for (int j = 0; j < p; j++) {
            long double score;
            int c;
            int mask = 0;
            fin>>score>>c;
            for (int k = 0; k < c; k++) {
                string l;
                fin>>l;
                if (um.find(l) == um.end()) {
                    node_names[um.size()] = l;
                    um[l] = um.size();
                }
                mask ^= (1<<um[l]);
            }
            local_scores[v][mask].set_log(score);
        }
    }
    fin.close();
}

Num potential_parents_weight(int v, int r, int t) {
    return zeta[v][t] - zeta[v][t ^ r];
}

void compute_cumulative() {
    for (int i = 0; i < n; i++) {
        zeta_transform(zeta[i], local_scores[i], n);
    }
}

void compute_subgraphs() {
    h = new Num[1<<n];
    h[0] = 1;
    for (int u = 1; u < (1<<n); u++) {
        h[u] = 0; 
        if (__builtin_popcount(u) > n - n / 2) continue;
        for (int s = u; s > 0; s = (s - 1) & u) {
            Num sink_w;
            sink_w = h[u ^ s];
            if (!isfinite(sink_w.value)) continue;
            for (int v = 0; v < n; v++) {
                if (s & (1<<v)) {
                    sink_w *= zeta[v][u ^ s];
                }
            }
            if (__builtin_popcount(s) % 2 == 0) {
                h[u] -= sink_w;
            } else {
                h[u] += sink_w;
            }
        }
    }

    g = new Num[1<<n];
    g[0] = 1;
    for (int u = 1; u < (1<<n); u++) {
        g[u] = 0;
        if (__builtin_popcount(u) > n / 2) continue;
        for (int r = u; r > 0; r = (r - 1) & u) {
            Num sink_w;
            sink_w = g[u ^ r];
            if (!isfinite(sink_w.value)) continue;
            for (int v = 0; v < n; v++) {
                if (r & (1<<v)) {
                    sink_w *= zeta[v][((1<<n) - 1) ^ u];
                }
            }
            if (__builtin_popcount(r) % 2 == 0) {
                g[u] -= sink_w;
            } else {
                g[u] += sink_w;
            }
        }
    }
}

void compute_forward_weights(int u) {
    int l = __builtin_popcount(u);
    for (int i = 0; i < (1<<l); i++) {
        forward_weights[i] = g[expand(i, u)];
    }
    for (int vi = 0; vi < l; vi++) {
        Num weight = -zeta[ __builtin_ctz(expand(1<<vi, u))][((1<<n) - 1) ^ u];
        for (int i = (1<<vi); i < (1<<l); i += (2<<vi)) {
            for (int j = i; j < i + (1<<vi); j++) {
                forward_weights[j] += forward_weights[j - (1<<vi)] * weight;
            }
        }
    }
    reverse(forward_weights, forward_weights + (1<<l));
}

void compute_backward_weights(int u) {
    int l = __builtin_popcount(u);
    Num backward_weights_hat[1<<l];
    int index = (1<<l) - 1;
    for (int s = u; s > 0; s = (s - 1) & u) {
        backward_weights_hat[index] = h[u ^ s];
        for (int v = 0; v < n; v++) {
            if (s & (1<<v)) {
                backward_weights_hat[index] *= zeta[v][u ^ s];
            }
        }
        index--;
    }
    backward_weights_hat[0] = h[u];

    reverse(backward_weights_hat, backward_weights_hat + (1<<l));
    mobius_inverse(backward_weights, backward_weights_hat, l);
    reverse(backward_weights, backward_weights + (1<<l));
}

Num uniform_random(Num ub) {
    uniform_real_distribution<> uniform_dist(0, 1);
    return uniform_dist(gen) * ub;
}

int weighted_sample(Num* arr, int l) {
    Num sum;
    sum = 0;
    for (int i = 0; i < l; i++) {
        sum += arr[i];
    }
    Num pos = uniform_random(sum);
    for (int index = 0; index < l; index++) {
        pos -= arr[index];
        if (pos < 0) {
            return index;
        }
    }
    return -1;
}

int sample_parents(int v, int r, int t) {
    // sample first at most n/2 parents with inclusion-exclusion, then naively from remaining n/2 remaining potential parents with local scores => O(2^{n/2})
    int parents = 0;
    for (int w = 0; w < n; w++) {
        if (r & (1<<w)) {
            Num include[2] = {zeta[v][t ^ (1<<w)] - zeta[v][t ^ r], zeta[v][t] - zeta[v][t ^ (1<<w)]};
            if (weighted_sample(include, 2)) {
                parents = (1<<w);
                t ^= (1<<w);
                break;
            } else {
                t ^= (1<<w);
                r ^= (1<<w);
            }
        }
    }
    int half = __builtin_popcount(t) / 2;
    for (int w = 0; w < n; w++) {
        if (__builtin_popcount(t) <= half) {
            break;
        }
        if (t & (1<<w)) {
            t ^= (1<<w);

            // inclusion-exclusion properties: parent set includes parents[i]
            
            Num include[2] = {0, 0};
            Num norm = zeta[v][t ^ parents];
            Num any_missing;
            any_missing = 0;
            for (int missing = parents; missing > 0; missing = (missing - 1) & parents) {
                if (__builtin_popcount(missing) % 2 == 1) {
                    any_missing += zeta[v][t ^ parents ^ missing];
                } else {

                    any_missing -= zeta[v][t ^ parents ^ missing];
                }
            }
            include[0] = norm - any_missing;

            parents ^= (1<<w);
            norm = zeta[v][t ^ parents];
            any_missing = 0;
            for (int missing = parents; missing > 0; missing = (missing - 1) & parents) {
                if (__builtin_popcount(missing) % 2 == 1) {
                    any_missing += zeta[v][t ^ parents ^ missing];
                } else {

                    any_missing -= zeta[v][t ^ parents ^ missing];
                }
            }
            include[1] = norm - any_missing;

            if (!weighted_sample(include, 2)) {
                parents ^= (1<<w);
            }
        }
    }
    int l = __builtin_popcount(t);
    Num pr[1<<l];
    for (int i = 0; i < (1<<l); i++) {
        pr[i] = local_scores[v][expand(i, t) ^ parents];
    }
    return expand(weighted_sample(pr, 1<<l), t) ^ parents;
}

vector<pair<int, int>> sample(int u, bool few) {
    vector<pair<int, int>> graph;
    int forward = u;
    int previous = ((1<<n) - 1) ^ u;
    while (forward) {
        int f_count = __builtin_popcount(forward);
        Num weights[1<<f_count];
        weights[0] = 0;
        compute_forward_weights(forward);
        for (int index = 1; index < (1<<f_count); index++) {
            int r = expand(index, forward);
            weights[index] = forward_weights[index];
            for (int v = 0; v < n; v++) {
                if (r & (1<<v)) {
                    weights[index] *= potential_parents_weight(v, previous, ((1<<n) - 1) ^ forward);
                }
            }
        }
        int layer = expand(weighted_sample(weights, 1<<f_count), forward);
        for (int v = 0; v < n; v++) {
            if (layer & (1<<v)) {
                int parents = sample_parents(v, previous, ((1<<n) - 1) ^ forward);
                for (int j = 0; j < n; j++) {
                    if (parents & (1<<j)) {
                        graph.push_back({j, v});
                    }
                }
            }
        }
        forward ^= layer;
        previous = layer;
    }

    if (few) {
        return graph;
    }
    
    int backward = ((1<<n) - 1) ^ u;
    if (backward) {
        int b_count = __builtin_popcount(backward);
        Num weights[1<<b_count];
        weights[0] = 0;
        compute_backward_weights(backward);
        for (int index = 1; index < (1<<b_count); index++) {
            weights[index] = backward_weights[index];
        }
        int layer = expand(weighted_sample(weights, 1<<b_count), backward);
        backward ^= layer;
        previous = layer;
    }
    while (backward) {
        int b_count = __builtin_popcount(backward);
        Num cover_z[1<<b_count];
        for (int i = 0; i < (1<<b_count); i++) {
            cover_z[i] = 1;
        }
        for (int v = 0; v < n; v++) {
            if (previous & (1<<v)) {
                for (int p = backward; p > 0; p = (p - 1) & backward) {
                    cover_z[reduce(p, backward)] *= zeta[v][p];
                }
                cover_z[0] *= zeta[v][0];
            }
        }
        Num cover[1<<b_count];
        Num parent_weight[1<<b_count];
        mobius_inverse(cover, cover_z, b_count);
        reverse(cover, cover + (1<<b_count));
        zeta_transform(parent_weight, cover, b_count);
        reverse(parent_weight, parent_weight + (1<<b_count));

        Num weights[1<<b_count];
        weights[0] = 0;
        compute_backward_weights(backward);
        for (int index = 1; index < (1<<b_count); index++) {
            weights[index] = backward_weights[index] * parent_weight[index];
        }
        int layer = expand(weighted_sample(weights, 1<<b_count), backward);

        int uncovered = layer;
        for (int v = 0; v < n; v++) {
            if (previous & (1<<v)) {
                Num parent_weights[1<<b_count];
                for (int i = 0; i < (1<<b_count); i++) {
                    parent_weights[i] = local_scores[v][expand(i, backward)];
                }

                for (int i = 0; i < (1<<b_count); i++) {
                    cover_z[i] = 1;
                }
                for (int w = v + 1; w < n; w++) {
                    if (previous & (1<<w)) {
                        for (int p = backward; p > 0; p = (p - 1) & backward) {
                            cover_z[reduce(p, backward)] *= zeta[w][p];
                        }
                        cover_z[0] *= zeta[w][0];
                    }
                }
                mobius_inverse(cover, cover_z, b_count);
                reverse(cover, cover + (1<<b_count));
                zeta_transform(parent_weight, cover, b_count);
                reverse(parent_weight, parent_weight + (1<<b_count));

                for (int index = 0; index < (1<<b_count); index++) {
                    int r = expand(index, backward);
                    parent_weights[index] *= parent_weight[reduce(uncovered & ~r, backward)];
                }

                int parents = expand(weighted_sample(parent_weights, 1<<b_count), backward);
                uncovered &= ~parents;
                for (int j = 0; j < n; j++) {
                    if (parents & (1<<j)) {
                        graph.push_back({j, v});
                    }
                }
            }
        }
        backward ^= layer;
        previous = layer;
    }
    return graph;
}

bool test_acceptance(vector<pair<int, int>> v, int u) {
    int child_c[n];
    vector<int> parents[n];
    for (int v = 0; v < n; v++) {
        child_c[v] = 0;
    }
    stack<int> elim;
    for (pair<int, int> p : v) {
        parents[p.second].push_back(p.first);
        child_c[p.first]++;
    }
    for (int v = 0; v < n; v++) {
        if (parents[v].empty()) {
            child_c[v] = n + 1;
        }
    }
    for (int v = 0; v < n; v++) {
        if (!child_c[v]) {
            elim.push(v);
        }
    }
    for (int i = 0; i < n / 2; i++) {
        int v = elim.top();
        elim.pop();
        if ((1<<v) & ~u) return false;
        u ^= (1<<v);
        for (int p : parents[v]) {
            child_c[p]--;
            if (!child_c[p]) {
                elim.push(p);
            }
        }
    }
    return true;
}

void preprocess() {
    forward_weights = new Num[1<<n];
    backward_weights = new Num[1<<n];
    compute_cumulative();
    compute_subgraphs();
}

int main(int argc, char *argv[]) {
    boost_gen.seed(time(0));
    gen.seed(time(0));
    
    start_time = chrono::steady_clock::now();

    read_input(string(argv[1]));
    preprocess();

    Num upper_bound;
    upper_bound = 0;
    Num sum_table[1<<n];
    sum_table[0] = 0;
    for (int u = 0; u < (1<<n); u++) {
        if (u) sum_table[u] = sum_table[u - 1];
        if (__builtin_popcount(u) > n / 2) continue;
        compute_forward_weights(u);
        if (__builtin_popcount(u) == n / 2) {
            for (int i = 1; i < (1<<(n / 2)); i++) {
                Num weight = h[((1<<n) - 1) ^ u] * forward_weights[i];
                for (int j = 0; j < n; j++) {
                    if ((1<<j) & expand(i, u)) {
                        weight *= potential_parents_weight(j, ((1<<n) - 1) ^ u, ((1<<n) - 1) ^ u);
                    }
                }
                upper_bound += weight;
                sum_table[u] += weight;
            }
        } else {
            for (int i = 1; i < (1<<(__builtin_popcount(u))); i++) {
                Num weight = forward_weights[i];
                for (int j = 0; j < n; j++) {
                    if ((1<<j) & expand(i, u)) {
                        weight *= potential_parents_weight(j, ((1<<n) - 1) ^ u, ((1<<n) - 1) ^ u);
                    } else if (!(u & (1<<j))) {
                        weight *= local_scores[j][0];
                    }
                }
                upper_bound += weight;
                sum_table[u] += weight;
            }
        }
    }

    if (!isfinite(upper_bound.value)) {
        cout<<"No DAGs"<<endl;
        return 0;
    }

    long double preprocessing_time = time_since(start_time);

    uniform_real_distribution<> uniform_dist(0, 1);
    exponential_distribution<double> expd(1);

    cout<<setprecision(10)<<fixed;
    int K = 10000;
    int accepted = 0;
    while (accepted != K) {
        int u = -1;
        Num u_pos;
        u_pos = uniform_dist(gen) * sum_table[(1<<n) - 1];
        for (int l = (1<<n); l > 0; l /= 2) {
            if (u + l < (1<<n) && sum_table[u + l] < u_pos) {
                u += l;
            }
        }
        u++;
        auto graph = sample(u, __builtin_popcount(u) != n / 2);

        if (__builtin_popcount(u) != n / 2 || test_acceptance(graph, u)) {
            accepted++;
            Num score;
            score = 1;
            for (int i = 0; i < n; i++) {
                int mask = 0;
                for (pair<int, int> p : graph) {
                    if (p.second == i) {
                        mask += 1<<p.first;
                    }
                }
                score *= local_scores[i][mask];
            }
            cout<<score<<" ";
            for (int i = 0; i < n; i++) {
                if (i) cout<<" ";
                cout<<node_names[i]<<"<-";
                bool first = true;
                for (pair<int, int> p : graph) {
                    if (p.second == i) {
                        if (!first) cout<<",";
                        cout<<node_names[p.first];
                        first = false;
                    }
                }
            }
            cout<<endl;
        }
    }

    long double sampling_time = time_since(start_time) - preprocessing_time;
    long double average_time = sampling_time / K;
    
    cerr<<"Preprocessing:  "<<preprocessing_time<<"s"<<endl;
    cerr<<"Sampling:       "<<sampling_time<<"s"<<endl;
    cerr<<"Per sample:     "<<average_time<<"s"<<endl;
}