# HGTFT

## Environment Requirements

- Python 3.9.16
- PyTorch 2.1.0
- Other dependencies are listed in `requirements.txt`

### Create and Activate Virtual Environment (Optional but Recommended)

```shell
bash python -m venv venv source venv/bin/activate # For Windows, use: venv\Scripts\activate
```

### Install Dependencies

```shell
bash pip install -r requirements.txt
```


### Verify Environment Configuration

The configuration files are located in the `config` folder under the project root directory.

## Model Setup

Download the model files from the following link:

[Download Model](https://drive.google.com/drive/folders/156rHrWkZyLnlMsFYl4qwFdGvm5YoS3-l?usp=drive_link)

After downloading, place the model files in the `model_file` folder under the project root directory. If this folder does not exist, create it manually.

## Data Download

If you wish to train or fine-tune the model, download the dataset using the link below:

[Download Dataset](https://drive.google.com/drive/folders/1gH-S-1uY_JhpY3x_VcKgztHpccCWXsVV?usp=drive_link)

This dataset contains 50 samples of simulated data. After downloading, extract the files and place them in the `data` directory of the project.

## Running the Program

### 1. Dataset Construction

**Step 1:** Edit the configuration file:  
`config/hgtft_data_process.yaml`  

Update the following paths to match the absolute path of the `data` folder in your project root directory:
- `original_data_path`
- `normalization_data_path`
- `dataset_data_path`

**Step 2:** Run the dataset construction command:

```shell
bash python main.py --config_name hgtft_data_process
```

### 2. Model Training

**Step 1:** Edit the configuration file:  
`config/hgtft_train.yaml`  

Update:
- `dataset_data_path`: Absolute path to the `data` folder  
- `project_train`: List of sample data names for training  

**Step 2:** Run the training command:

```shell
bash python main.py --config_name hgtft_train
```

### 3. Model Finetuning

**Step 1:** Edit the configuration file:  
`config/hgtft_finetuning.yaml`  

Update:
- `dataset_data_path`: Absolute path to the `data` folder  
- `project_train`: List of sample data names for training  
- `reuse_structure.model.name`: Name of the pre-trained model  
- `reuse_structure.model.layers`: Layers or parameters to reuse  
- `freeze_layers`: Layers to freeze during training  

**Step 2:** Run the finetuning command:
```shell
bash python main.py --config_name hgtft_finetuning
```

### 4. Model Inference

**Step 1:** Edit the configuration file:  
`config/hgtft_inference.yaml`  

Set:
- `test_data`: Sample(s) you want to predict  

**Step 2:** Run the inference command:

```shell
bash python main.py --config_name hgtft_inference
```

> ✅ Prediction results will be saved in the `output` directory.

