# -*- coding: utf-8 -*-
import os
import omegaconf
ROOT_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


def load_config(config_name: str) -> omegaconf.DictConfig:
    # private
    config_path = os.path.join(ROOT_DIR, 'config', f'{config_name}.yaml')
    if not os.path.exists(config_path):
        raise IOError(f"no config file: {config_name}")
    config = omegaconf.OmegaConf.load(config_path)
    # public
    public_config_path = os.path.join(ROOT_DIR, 'config', 'hgtft_base.yaml')
    if not os.path.exists(public_config_path):
        raise IOError(f"no config file: {public_config_path}")
    public_config = omegaconf.OmegaConf.load(public_config_path)
    merged_config = omegaconf.OmegaConf.merge(public_config, config)
    return merged_config


def _load_time_config() -> omegaconf.DictConfig:
    config_path = os.path.join(ROOT_DIR, 'config/time.yaml')
    config = omegaconf.OmegaConf.load(config_path)
    return config


time_config = _load_time_config()
