# -*- coding: utf-8 -*-
import os
import logging
from datetime import datetime
from logging.handlers import TimedRotatingFileHandler


class MyLog:
    def __init__(self, filename, log_name, log_root_path=""):
        self.logger = logging.getLogger(log_name)
        self.logger.setLevel(logging.INFO)
        self.log_type = filename
        self.log_root_path = log_root_path if log_root_path != "" else os.path.dirname(
            os.path.dirname(os.path.realpath(__file__)))

        # create Handler
        console_handler = logging.StreamHandler()
        console_handler.setLevel(logging.INFO)

        logfile_name = "{}_{}.log".format(filename, datetime.now().strftime('%Y-%m-%d'))
        if not os.path.exists(os.path.join(self.log_root_path, "log")):
            os.makedirs(os.path.join(self.log_root_path, "log"))
        logfile = os.path.join(os.path.join(self.log_root_path, "log"), logfile_name)

        file_handler = TimedRotatingFileHandler(logfile, when='midnight', interval=1, backupCount=30, encoding='UTF-8')
        file_handler.setLevel(logging.INFO)

        formatter = logging.Formatter('%(asctime)s - %(filename)s[line:%(lineno)d] - %(levelname)s - %(message)s')
        file_handler.setFormatter(formatter)
        console_handler.setFormatter(formatter)

        self.logger.addHandler(console_handler)
        self.logger.addHandler(file_handler)

    def get_logger(self):
        return self.logger


access_log = MyLog("access_log", "access").get_logger()
