# -*- coding: utf-8 -*-
import pyecharts.options as opts
from pyecharts.charts import Line, Page
import pandas as pd
import pickle
import gzip
import os
from datetime import datetime, timedelta



def load_data(path):
    if path.endswith('gz'):
        with gzip.open(path, 'rb') as f:
            data = pickle.load(f)
        return data
    elif path.endswith('pickle'):
        with open(path, 'rb') as fp:
            data = pickle.load(fp)
        return data
    else:
        raise ValueError(path)

def make_html(config):
    task_id = config.use_task[0]
    time_start = (datetime.strptime(config.data.time.test_start, '%Y-%m-%d %H:%M:%S') +
                  timedelta(minutes=config.configuration.model.history_len * 15)).strftime('%Y-%m-%d %H:%M:%S')
    time_end = config.data.time.test_end
    for sample_name in config.test_data:
        time_list_quarter = pd.date_range(time_start, time_end, freq='15min', inclusive='left').tolist()
        time_list_day = pd.date_range(time_start, time_end, freq='1D', inclusive='left').tolist()
        predict = load_data(os.path.join('./output/{}.pkl.gz'.format(sample_name)))
        page = Page()
        for obj_type in predict.get(task_id).keys():
            obj_id = list(predict.get(task_id).get(obj_type).keys())[0]

            predict_zone_feature_list = list(predict.get(task_id).get(obj_type).get(obj_id).get('predict').keys())
            line = Line(init_opts=opts.InitOpts(width="1600px", height="500px"))
            line.add_xaxis(time_list_quarter)

            for feature_index, feature_name in enumerate(predict_zone_feature_list):
                predict_tdb = [round(i, 3) for i in
                               predict.get(task_id).get(obj_type).get(obj_id).get('predict').get(feature_name)]
                target_tdb = [round(i, 3) for i in
                              predict.get(task_id).get(obj_type).get(obj_id).get('target').get(feature_name)]

                if feature_index == 0:
                    line.add_yaxis(f'pridict_{feature_name}', predict_tdb, symbol_size=2, is_symbol_show=False,
                                   linestyle_opts=opts.LineStyleOpts(width=1))
                    line.add_yaxis(f'actually_{feature_name}', target_tdb, symbol_size=2, is_symbol_show=False,
                                   linestyle_opts=opts.LineStyleOpts(width=1, type_='dashed'))
                else:
                    line.add_yaxis(f'pridict_{feature_name}', predict_tdb, symbol_size=2, is_symbol_show=False,
                                   linestyle_opts=opts.LineStyleOpts(width=1))
                    line.add_yaxis(f'actually_{feature_name}', target_tdb, symbol_size=2, is_symbol_show=False,
                                   linestyle_opts=opts.LineStyleOpts(width=1, type_='dashed'))

            line.set_series_opts(
                markline_opts=opts.MarkLineOpts(data=[opts.MarkLineItem(x=i) for i in time_list_day],
                                                label_opts=opts.LabelOpts(is_show=False))
            )
            line.set_global_opts(
                title_opts=opts.TitleOpts(subtitle=f"{obj_type} {obj_id}"),
                yaxis_opts=opts.AxisOpts(axislabel_opts=opts.LabelOpts(formatter="{value}")),
                xaxis_opts=opts.AxisOpts(splitarea_opts=opts.SplitAreaOpts(is_show=True),
                                         splitline_opts=opts.SplitLineOpts(is_show=False)),
                datazoom_opts=[opts.DataZoomOpts(orient='horizontal', range_start=0, range_end=100),
                               opts.DataZoomOpts(orient="vertical", range_start=0, range_end=100)],
                tooltip_opts=opts.TooltipOpts(trigger_on="mousemove|click", axis_pointer_type='cross',
                                              trigger='axis', ),
                legend_opts=opts.LegendOpts(type_="scroll", pos_left='10%', selector=True)
            )

            line.set_series_opts(
                label_opts=opts.LabelOpts(is_show=False)
            )
            page.add(line)

        page.render('./output/{}.html'.format(sample_name))
