#AIRCL Project Documentation

## Introduction
This repository contains several projects, each implementing a different generative algorithm with distinct objective functions for the modified MuJoCo environment. Due to these variations, the projects are not integrated into a single repository but are instead maintained separately to allow for independent testing of each environment.

## Project Structure
Each baseline algorithm is housed in its own project to address the unique definitions and target functions associated with each generative algorithm. This structure ensures that modifications specific to an algorithm do not interfere with others, allowing for more controlled and accurate evaluations.

### Special Versions
- Projects that include versions without regularization terms are marked with the suffix "no" in the project name.
- The linear version of the Constrained AIRL algorithm is denoted as `CCAIRLLinear`.
- The version of the Constrained AIRL algorithm that is based on single action-state pairs is labeled as `CCAIRLsa`.

## Environment Setup
- **Python Environment:** Anaconda
- **Python Version:** 3.9
- **MuJoCo Version:** 1.50.2
- **Operating System:** Windows 11

Each environment is tested separately to ensure the integrity and functionality of the implementations under the specified setup.

## Documentation
Detailed documentation for each modified MuJoCo environment is available within the respective project directories under the `Environment` section. This includes specific configurations, modified parameters, and any additional setup information required to replicate the testing conditions.

## Getting Started
To get started with any of the projects, please refer to the specific project directory for instructions on installation, environment setup, and running the tests. It is crucial to follow the individual setup guidelines to ensure that the environment is correctly configured for the intended experiments.
