import pandas as pd

def calculate_action_violation_rate(trajectories):
    total_actions = 0
    violations = 0

    for traj in trajectories:

        total_actions += len(traj.acts)

        for action in traj.acts:
            if abs(action[0]) < 0.5 or abs(action[1]) < 0.5:
                violations += 1

    violation_rate = violations / total_actions if total_actions > 0 else 0

    csv_file_path = r'.\New_Violation_Rate\CCAIRL_Swimmerno.csv'

    df = pd.DataFrame({'violation_rate': [violation_rate]})

    with open(csv_file_path, encoding='utf-8-sig', mode='a', newline='') as f:
        df.to_csv(f, header=f.tell() == 0, index=False)

    return violation_rate