import pandas as pd

def calculate_observation_violation_rate(trajectories):
    total_observations = 0
    violations = 0

    for traj in trajectories:
        total_observations += len(traj.obs)
        for obs in traj.obs:
            if obs[0] < - 0.01:
                violations += 1

    violation_rate = violations / total_observations if total_observations > 0 else 0

    csv_file_path = r'.\New_Violation_Rate\CCAIRL_Inverse.csv'

    df = pd.DataFrame({'violation_rate': [violation_rate]})
    with open(csv_file_path, encoding='utf-8-sig', mode='a', newline='') as f:
        df.to_csv(f, header=f.tell() == 0, index=False)

    return violation_rate
