import pandas as pd


def calculate_violation_rate(trajectories):

    forbidden_coordinates = {(3, 0), (3, 1), (3, 2), (3, 3), (3, 4)}
    total_observations = 0
    violations = 0

    for traj in trajectories:

        for obs in traj.obs:
            total_observations += 1

            if tuple(obs) in forbidden_coordinates:
                violations += 1

    violation_rate = violations / total_observations if total_observations > 0 else 0

    csv_file_path = r'.\New_Violation_Rate\ICRL_Gridno.csv'

    df = pd.DataFrame({'violation_rate': [violation_rate]})

    with open(csv_file_path, encoding='utf-8-sig', mode='a', newline='') as f:
        df.to_csv(f, header=f.tell() == 0, index=False)

    return violation_rate