import torch
import numpy as np
from tools import builder
from utils import misc, dist_utils
from utils.logger import *


def run_net(args, config, train_writer=None, val_writer=None):
    logger = get_logger(args.log_name)
    # build dataset
    _, test_dataloader = builder.dataset_builder(args, config.dataset.test)

    # build model
    base_model = builder.model_builder(config.model)
    if args.use_gpu:
        base_model.to(args.local_rank)
    base_model.zero_grad()
    base_model.eval()

    points_list = []
    gt_points_list = []
    upsample_points_list = []

    with torch.no_grad():
        for taxonomy_ids, model_ids, data, *_ in test_dataloader:
            gt_points = data.cuda()
            points = misc.fps(gt_points, config.points_num)
            upsample_points = base_model.upsample(points)

            points_list.append(points.cpu().numpy())
            gt_points_list.append(gt_points.cpu().numpy())
            upsample_points_list.append(upsample_points.cpu().numpy())

    points = np.concatenate(points_list, axis=0)
    gt_points = np.concatenate(gt_points_list, axis=0)
    upsample_points = np.concatenate(upsample_points_list, axis=0)

    upsample_data = {
        'points': points,
        'upsample_points': upsample_points,
        'gt_points': gt_points
    }
    np.save('upsample_data.npy', upsample_data)
    print('Successfully save completion data to upsample_data.npy')
