import requests

def download_file(url, filename):
    try:
        response = requests.get(url, stream=True)
        response.raise_for_status()

        with open(filename, 'wb') as file:
            for chunk in response.iter_content(chunk_size=8192):
                file.write(chunk)
        print(f"Downloaded {filename} successfully.")

    except requests.exceptions.RequestException as e:
        print(f"Error downloading {url}: {e}")

file_url = "https://raw.githubusercontent.com/egozverev/Should-It-Be-Executed-Or-Processed/6c5ba9571947aa3d7c388c97e3e4867490a6157b/SEP_dataset/SEP_dataset.json"
local_filename = "./datasets/SEP_dataset.json"
download_file(file_url, local_filename)
