function han = getfcn(sys,params)
% getfcn - returns the function handle of the continuous function specified
%    by the linear system object
%
% Syntax:
%    han = getfcn(sys,params)
%
% Inputs:
%    sys - linearSys object
%    params - model parameters
%
% Outputs:
%    han - function handle
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Matthias Althoff
% Written:       07-May-2007 
% Last update:   20-March-2008
%                05-December-2017
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

han = @(t,x) sys.A*x + sys.B*params.u + sys.c + sys.E*params.w;

% ------------------------------ END OF CODE ------------------------------
