function [Rfirst,options] = initReach(obj,Rinit,params,options)
% initReach - computes the reachable continuous set for the 
%    first time step in the Krylov subspace or Euclidean space
%
% Syntax:
%    [Rfirst,options] = initReach(obj,Rinit,params,options)
%
% Inputs:
%    obj - linearSys object
%    Rinit - initial reachable set
%    params - model parameters
%    options - options for the computation of the reachable set
%
% Outputs:
%    obj - linearSys object
%    Rfirst - first reachable set 
%    options - options for the computation of the reachable set
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Matthias Althoff
% Written:       07-November-2018
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% check whether error specification for Krylov space exists
if isfield(options,'krylovError')
    %compute in Krylov space
    [Rfirst,options] = initReach_Krylov(obj,Rinit,params,options);
else
    % compute in untransformed space
    [Rfirst,options] = initReach_Euclidean(obj,Rinit,params,options);
end

% ------------------------------ END OF CODE ------------------------------
