function [Rnext,options] = post(obj,~,params,options)
% post - calls the post functions in the standard or Krylov space
%
% Syntax:
%    [Rnext,options] = post(obj,~,params,options)
%
% Inputs:
%    obj - linearSys object
%    params - model parameters
%    options - options for the computation of the reachable set
%
% Outputs:
%    Rnext - reachable set of the next time step
%    options - options for the computation of the reachable set
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Matthias Althoff
% Written:       07-November-2018 
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% check whether error specification for Krylov space exists
if isfield(options,'krylovError')
    %compute in Krylov space
    [Rnext,options] = post_Krylov(obj,params,options);
else
    % compute in untransformed space
    [Rnext,options] = post_Euclidean(obj,params,options);
end

% ------------------------------ END OF CODE ------------------------------
