function han = getfcn(sys,params)
% getfcn - returns the function handle of the continuous function specified
%    by the DAE system object
%
% Syntax:
%    han = getfcn(sys,params)
%
% Inputs:
%    sys - nonlinDASys object
%    params - model parameters
%
% Outputs:
%    han - function handle
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Matthias Althoff
% Written:       17-November-2011
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

    function dxdt = f(t, z)
        %obtain x and y
        x = z(1:sys.dim);
        y = z((sys.dim+1):(sys.dim+sys.nrOfConstraints));
        
        %return derivatives
        dxdt(1:sys.dim,1) = sys.dynFile(x, y, params.u);
        dxdt((sys.dim+1):(sys.dim+sys.nrOfConstraints),1) = sys.conFile(x, y, params.u);
    end
    
    han = @f;

end

% ------------------------------ END OF CODE ------------------------------
