function [R,tcomp] = executeObserver(obj,params,options)
% executeObserver - calls the appropriate observer
%
% Syntax:
%    [R,tcomp] = executeObserver(obj,params,options)
%
% Inputs:
%    obj - nonlinearSysDT object
%    params - model parameters for the guaranteed state estimation
%    options - options for the guaranteed state estimation
%
% Outputs:
%    R - observed set of points in time
%    tcomp - computation time
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Matthias Althoff
% Written:       25-March-2021
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% decide which observer to execute by options.alg
switch options.alg
    case 'VolMin-A'
        [R,tcomp] = observe_volMinA(obj,params,options);
    case 'VolMin-B'
        [R,tcomp] = observe_volMinB(obj,params,options);
    case 'FRad-A'
        [R,tcomp] = observe_FRadA(obj,params,options);
    case 'FRad-B'
        [R,tcomp] = observe_FRadB(obj,params,options);
    case 'FRad-C'
        [R,tcomp] = observe_FRadC(obj,params,options);
end

% ------------------------------ END OF CODE ------------------------------
