function SpS = spectraShadow(hyp)
% spectraShadow - Converts a constrained hyperplane to a spectrahedral
%    shadow
%
% Syntax:
%    SpS = spectraShadow(hyp)
%
% Inputs:
%    hyp - conHyperplane object
%
% Outputs:
%    SpS - spectraShadow object
%
% Example:
%    hyp = conHyperplane(halfspace([1;1],0),[1 0;-1 0],[2;2]);
%    SpS = spectraShadow(hyp);
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: halfspace/spectraShadow

% Authors:       Adrian Kulmburg
% Written:       01-August-2023
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% Deduce dimension of ambient space
n = dim(hyp);

% Initialize constraints of the equality constraint
A0 = sparse([hyp.h.d 0; 0 -hyp.h.d]);
Ai = cell([1 n]);
for i = 1:n
    temp = [-hyp.h.c(i); hyp.h.c(i)];
    Ai{i} = spdiags(temp,0,2,2);
end

% Append constraints of the inequality constraints
if isempty(hyp.C)
    % If there are none, we are done      
else
    for j=1:size(hyp.C,1)
        A0 = blkdiag(A0, [hyp.d(j)]);
        for i=1:n
            Ai{i} = blkdiag(Ai{i}, [-hyp.C(j,i)]);
        end
    end
end

% Concatenate everything
A = [A0 cat(2,Ai{:})];

% instantiate spectraShadow
SpS = spectraShadow(A);

% Additional properties
SpS.bounded.val = isBounded(hyp);
SpS.emptySet.val = representsa_(hyp,'emptySet',1e-10);

% ------------------------------ END OF CODE ------------------------------
