function SpS = spectraShadow(hs)
% spectraShadow - Converts a halfspace to a spectrahedral shadow
%
% Syntax:
%    SpS = spectraShadow(hs)
%
% Inputs:
%    hs - halfspace object
%
% Outputs:
%    SpS - spectraShadow object
%
% Example:
%    hs = halfspace.generateRandom();
%    SpS = spectraShadow(hs);
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: ---

% Authors:       Adrian Kulmburg
% Written:       01-August-2023
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% Deduce dimension of ambient space
n = dim(hs);

% Initialize constraints of the inequality constraint
A0 = sparse([-hs.d]);
Ai = cell([1 n]);
for i = 1:n
    Ai{i} = sparse([-hs.c(i)]);
end

% Concatenate everything
A = [A0 cat(2,Ai{:})];

% instantiate spectraShadow
SpS = spectraShadow(A);
% Additional properties
SpS.bounded.val = isBounded(hs);
SpS.emptySet.val = representsa_(hs,'emptySet',1e-10);

% ------------------------------ END OF CODE ------------------------------
