function SpS_out = or(SpS,S)
% or - returns the convex hull over the union of a spectrahedral shadow and
%    a contSet object
%
% Syntax:
%    SpS_out = or(SpS,S)
%
% Inputs:
%    SpS - spectraShadow object
%    S - contSet object
%
% Outputs:
%    S - convex hull over the union of S1 and S2
%
% Example:
%    A0 = eye(4);
%    A1 = [-1 0 0 0;0 1 0 0;0 0 0 0;0 0 0 0];
%    A2 = [0 0 0 0;0 0 0 0;0 0 -1 0;0 0 0 1];
%    SpS = spectraShadow([A0 A1 A2]);
%    SpS_convHull = SpS | (SpS+[1;1]);
%    
%    hold on
%    plot(SpS)
%    plot(SpS+[1;1])
%    plot(SpS_convHull)
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Maximilian Perschl, Adrian Kulmburg
% Written:       16-May-2023 
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

SpS_out = convHull(SpS,S);
    
% ------------------------------ END OF CODE ------------------------------
