function res = example_neuralNetwork_transformer_medical_queries_pZ_03_snd()
% example_neuralNetwork_transformer_medical_queries_pZ_03_snd - example for the verification of a 
%    transformer neural network from 
%
% Syntax:
%    res = example_neuralNetwork_transformer_medical_queries_pZ_03_snd()
%
% Inputs:
%    -
%
% Outputs:
%    res - boolean
%
% References:
%    [1] Vaswani et al. "Attention is all you need", 2017
%
% Authors:       Rayen Mhadhbi
% Written:       01-Sep-2024
% Last update:   ---
% Last revision: ---
% ------------------------------ BEGIN CODE -------------------------------

% load nn
verbose = false;
nn_cora = neuralNetwork.readTransformerNetwork('/Users/rayenmhadhbi/PycharmProjects/BachelorArbeit/transformer_model_in_medical_queries_big_snd_modal.json', verbose);

% tokenized sentences
tokenized_sentences = {
    [101,  2129, 2411, 2003,  3671, 2005, 14978, 2015, 1029, 102, 0];
    [101, 2339, 2515, 2026, 3108, 3480, 1029, 102, 0];
    [101, 2129, 2000, 3066, 2007, 5458, 2159, 1998, 8300, 4167, 102, 0];
    [101, 2129, 2000, 3066, 2007, 23760, 5054, 28032, 7730, 1029, 102, 0];
    [101, 2151, 3891, 1997, 9113, 4053, 1029,  102, 0]
};


total_best_noise = 0;
total_numVerified = 0;

% iterate over all tokenized sentences
for i = 1:length(tokenized_sentences)
    input = tokenized_sentences{i};
    [best_noise, numVerified] = aux_verifyInstance(nn_cora, input);
    
    % accumulate results
    total_best_noise = total_best_noise + best_noise;
    total_numVerified = total_numVerified + numVerified;
end

% compute averages
avg_best_noise = total_best_noise / length(tokenized_sentences);
avg_numVerified = total_numVerified / length(tokenized_sentences);

fprintf('Average Largest Noise: %e\n', avg_best_noise);
fprintf('Average Number of Verified Entries: %f\n', avg_numVerified);

res = true;
end

function [best_noise, numVerified] = aux_verifyInstance(nn_cora, input)
% helper function to compute the largest noise for which verification is true
% and the number of verified entries for a given input

% make predictions
pred_1 = nn_cora.layers{1, 1}.evaluate(input);
pred_2 = nn_cora.layers{2, 1}.evaluate(pred_1);
pred_3 = nn_cora.layers{3, 1}.evaluate(pred_2);
pred_4 = nn_cora.layers{4, 1}.evaluate(pred_3);
pred_5 = nn_cora.layers{5, 1}.evaluate(pred_4);
pred_6 = nn_cora.layers{6, 1}.evaluate(pred_5);
pred_7 = nn_cora.layers{7, 1}.evaluate(pred_6);
pred_8 = nn_cora.layers{8, 1}.evaluate(pred_7);

[~, label] = max(pred_8);

% define embedding noise range
noise_range = logspace(log10(0.02), log10(0.03), 3);  
radii = zeros(size(noise_range));
isVerifiedArray = false(size(noise_range));

% iterate over noise range
for i = 1:length(noise_range)
    noise = noise_range(i);
    embedding = nn_cora.layers{1, 1}.evaluate(input);
    c = reshape(embedding, [], 1); 
    dim = length(c);
    G = noise * eye(dim);
    pZ = polyZonotope(c, G);
    options = struct();
    options.nn.num_generators = 1000;
    options.nn.add_approx_error_to_GI = true;
    options = nnHelper.validateNNoptions(options);

    pZ = nn_cora.layers{2, 1}.evaluate(pZ, options);
    pZ = nn_cora.layers{3, 1}.evaluate(pZ, options);
    pZ = nn_cora.layers{4, 1}.evaluate(pZ, options);
    pZ = nn_cora.layers{5, 1}.evaluate(pZ, options);
    pZ = nn_cora.layers{6, 1}.evaluate(pZ, options);
    pZ = nn_cora.layers{7, 1}.evaluate(pZ, options);
    %pZ = nn_cora.layers{6, 1}.evaluate(pZ, options);

    int = interval(pZ);
    inf = reshape(int.inf, 2, 1);
    sup = reshape(int.sup, 2, 1);
    int = interval(inf, sup);
    
    M = [1 -1; 0 0];
    inf = M * int.inf;
    sup = M * int.sup; 
    r = radius(M* int);
    radii(i) = r;
   

    label_pred = interval(inf(label), sup(label));
    other_pred = interval(inf(2-label+1), sup(2-label+1));

    isVerified = all(other_pred.sup < label_pred.inf);
    isVerifiedArray(i) = isVerified;  
end

% binary search to find the largest noise value for which isVerifiedArray is true
left = 1;
right = length(noise_range);
best_noise = noise_range(left);

while left <= right
    mid = floor((left + right) / 2);
    if isVerifiedArray(mid)
        best_noise = noise_range(mid);
        left = mid + 1;
    else
        right = mid - 1;
    end
end

numVerified = sum(isVerifiedArray);

fprintf('Largest noise for which verification is true (refined): %e\n', best_noise);
fprintf('Number of verified entries: %d\n', numVerified);

end

% ------------------------------ END OF CODE ------------------------------
