function res = example_neuralNetwork_transformer_yelp()
% example_neuralNetwork_transformer - example for the verification of a 
%    transformer neural network from 
%
% Syntax:
%    res = example_neuralNetwork_transformer_yelp()
%
% Inputs:
%    -
%
% Outputs:
%    res - boolean
%
% References:
%    [1] Vaswani et al. "Attention is all you need", 2017
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Rayen Mhadhbi
% Written:       05-July-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% load nn
verbose = false;
nn_cora = neuralNetwork.readTransformerNetwork('/Users/rayenmhadhbi/PycharmProjects/BachelorArbeit/yelp_model/transformer_model_yelp.json', verbose);
display(nn_cora)
mn = min(nn_cora.layers{1, 1}.token_emb(:));
mx = max(nn_cora.layers{1, 1}.token_emb(:));
display(mn);
display(mx);

% define the input array
input = [101 1045 2018 1037 10392 3325 2012 3533 1521 1055 4157 4497 ...
    1012 1996 22466 9153 2015 2020 5379 1010 1996 2572 15599 3401 ...
    2001 26931 1010 1998 1996 6178 14289 14693 3630 2001 12090 1012 ...
    1045 3811 16755 2023 2173 102];

% Make predictions
pred_1 = nn_cora.layers{1, 1}.evaluate(input);
pred_2 = nn_cora.layers{2, 1}.evaluate(pred_1);
pred_3 = nn_cora.layers{3, 1}.evaluate(pred_2);
pred_4 = nn_cora.layers{4, 1}.evaluate(pred_3);
pred_5 = nn_cora.layers{5, 1}.evaluate(pred_4);
pred_6 = nn_cora.layers{6, 1}.evaluate(pred_5);
pred_7 = nn_cora.layers{7, 1}.evaluate(pred_6);
pred_8 = nn_cora.layers{8, 1}.evaluate(pred_7);

[~, label] = max(pred_8);
fprintf("Most likely label is: %d\n", label-1);

% Define embedding noise range
noise_range = logspace(-6, log10(0.0001), 100);  
radii = zeros(size(noise_range));
isVerifiedArray = false(size(noise_range));

for i = 1:1
    noise = 0.0001;
    
    % Evaluate the embedding layer
    embedding = nn_cora.layers{1, 1}.evaluate(input);
    c = reshape(embedding, [], 1); 
    dim = length(c);
    
    % Initialize generator matrix G
    G = noise * eye(dim);
    
    
    % Convert to polyZonotope with noise added to the specific diagonal entries
    int = polyZonotope(c, G);
    int = interval(int);
    inf = reshape(int.inf, 42, 64);
    sup = reshape(int.sup, 42, 64);
    int = interval(inf, sup);
    
    options = struct();
    options.nn.num_generators = 3000;
    options.nn.add_approx_error_to_GI = true;
    options = nnHelper.validateNNoptions(options);

    % Propagate through the network layers
    int = nn_cora.layers{2, 1}.evaluate(int, options);
    int = nn_cora.layers{3, 1}.evaluate(int, options);
    int = nn_cora.layers{4, 1}.evaluate(int, options);
    int = nn_cora.layers{5, 1}.evaluate(int, options);
    int = nn_cora.layers{6, 1}.evaluate(int, options);
    int = nn_cora.layers{7, 1}.evaluate(int, options);
    int = nn_cora.layers{8, 1}.evaluate(int, options);

    M = [1 -1; 0 0];
    inf = M * int.inf';
    sup = M * int.sup'; 
    r = radius(interval(int.inf', int.sup'));
    radii(i) = r; 

    label_pred = interval(inf(label), sup(label));
    other_pred = interval(inf(2-label+1), sup(2-label+1));

    isVerified = all(other_pred.sup < label_pred.inf);
    isVerifiedArray(i) = isVerified;  
end

figure;
hold on;
grid on;
xlabel('Embedding Noise');
ylabel('Radius of Intervals');
title('Certification Radii for different noise values');

% plot verified radii in one color (e.g., blue)
semilogx(noise_range(isVerifiedArray), radii(isVerifiedArray), 'bo', 'MarkerFaceColor', 'b');

% plot non-verified radii in another color (e.g., red)
semilogx(noise_range(~isVerifiedArray), radii(~isVerifiedArray), 'ro', 'MarkerFaceColor', 'r');

legend('Verified Radii', 'Non-verified Radii');
hold off;

res = true;
end

% ------------------------------ END OF CODE ------------------------------

