function output = affineMap(input, W, b)
% affineMap - compute the affine map of the input 
%
% Syntax:
%    out = nnHelper.affineMap(input, W, b)
%
% Inputs:
%    input - input matrix
%    W - weight matrix
%    b - bias term
%
% Outputs:
%    output - output matrix representing affine map of input
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Tobias Ladner
% Written:       20-June-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

[k, m] = size(W);  
[nk, h] = size(input);  
n = nk / k;  

output = pagemtimes(reshape(input, n, k, h), W);

output = output + b';


%reshape back to vector shape
output = reshape(output, n * m, h);

end

% ------------------------------ END OF CODE ------------------------------
