function [G,id] = mergeLabelledGenerators(G1,id1,G2,id2)
% mergeLabelledGenerators - merges generator matrices with
%
% Syntax:
%    [G,id] = mergeLabelledGenerators(G1,id1,G2,id2)
%
% Inputs:
%    G1 - first generator matrix
%    id1 - first label ids
%    G2 - second generator matrix
%    id2 - second label ids
%    
% Outputs:
%    G - merged generator matrix
%    id - merged label ids
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Tobias Ladner
% Written:       22-September-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% remove independnt part
h1 = numel(id1); h2 = numel(id2);
G_ind = [G1(:,h1+1:end) G2(:,h2+1:end)]; 
G1 = G1(:,1:h1); G2 = G2(:,1:h2);

% merge ids
id = unique([id1,id2]);

% extend generator matrices accordingly
if ~isempty(id1)
    G1 = G1 * (id1' == id);
end
if ~isempty(id2)
    G2 = G2 * (id2' == id);
end

% merge generators
if isempty(G1) && isempty(G2)
    G = G_ind;
elseif isempty(G1)
    G = [G2 G_ind];
elseif isempty(G2)
    G = [G1 G_ind];
else
    G = [G1 + G2 G_ind];
end

end

% ------------------------------ END OF CODE ------------------------------
