function output = transpose(input, k)
% transpose - compute the transpose of the input  
%
% Syntax:
%    out = nnHelper.transpose(input, k)
%
% Inputs:
%    input - input matrix
%    k - dimension to reshape input 
%
% Outputs:
%    output - output matrix representing transpose of input
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Tobias Ladner
% Written:       20-June-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

[nk, h] = size(input);  
n = nk / k; 
output = reshape(input, n , k, h);
output = permute(output, [2, 1, 3]);
[n, k, h] = size(output);
output = reshape(output, n * k, h);

end

% ------------------------------ END OF CODE ------------------------------
