function sig = until(lhs,interval,rhs)
% until - compute the until combination of two signals
%
% Syntax:
%    sig = until(lhs,interval,rhs)
%
% Inputs:
%    lhs - left-hand side signal
%    interval - time interval of the until operator
%    rhs - right-hand side signal
%
% Outputs:
%    sig - the combined signal
%
% Example:
%    lhs = pointSegmentSignal(0,[true true]);
%    rhs = pointSegmentSignal([0 4 7],[false false true true true false]);
%    int = stlInterval(1, 2);
%    sig = until(lhs,int,rhs);
%    assert(sig == pointSegmentSignal([0 2 6],[false false true true true false]));
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Florian Lercher
% Written:       12-February-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% find the positive intervals
lhsInt = lhs.findIntervals();
rhsInt = rhs.findIntervals();

% set to true wherever we find a witness for until
sig = intervalUntil(lhsInt,interval,rhsInt);

% ------------------------------ END OF CODE ------------------------------
