function res = test_conPolyZono_plot
% test_conPolyZono_plot - unit test function of plot;
%    this function aims to go through many variations of input arguments
%    note: only run-time errors checked, manual bug check necessary
%
% Syntax:
%    res = test_conPolyZono_plot
%
% Inputs:
%    -
%
% Outputs:
%    res - true/false
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Mark Wetzlinger
% Written:       25-May-2022
% Last update:   09-May-2023 (TL, added plotted point checks)
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

resvec = [];

% construct constrained polynomial zonotope
c = [0;0];
G = [1 0 1 -1; 0 1 1 1];
E = [1 0 1 2; 0 1 1 0; 0 0 1 1];
A = [1 -0.5 0.5];
b = 0.5;
EC = [0 1 2; 1 0 0; 0 1 0];
cPZ = conPolyZono(c,G,E,A,b,EC);

try
    % try all variations in plotting
    figure;
    
    % one argument: object
    plot(cPZ);
    resvec(end+1) = true;
    
    % two arguments: object, dimensions
    plot(cPZ,1);
    plot(cPZ,[1,2]);
    resvec(end+1) = true;
    
    % three arguments: object, dimensions, NVpairs
    plot(cPZ,[1,2],'LineWidth',2);
    plot(cPZ,[1,2],'Color',[.6 .6 .6],'LineWidth',2);
    plot(cPZ,[1,2],'FaceColor',[.6 .6 .6]);
    resvec(end+1) = true;

    % check if plotted correctly
    ax = gca();
    colorOrder = ax.ColorOrder;
    
    % plot set
    plot(cPZ,[1,2]);
    V = [ ...
     0.5048980712890625, 0.4975891113281250, 0.4978179931640625, 0.5002441406250000, 0.5073394775390625, 0.5080566406250000, 0.5956878662109375, 0.6029968261718750, 0.6029916869867212, 0.6402435302734375, 0.6400274990091788, 0.6455841064453125, 0.6278826215087887, 0.6279144287109375, 0.6276745849067688, 0.6226528751275887, 0.6222611629875350, 0.6345520019531250, 0.6377756063220550, 0.6378479003906250, 0.6378286261307550, 0.6516418457031250, 0.6477966308593750, 0.6397277535384049, 0.6541812723060594, 0.6553268432617188, 0.6743392944335938, 0.6743087768553594, 0.6743087768554688, 0.6874923706054688, 0.7094955444335938, 0.7094650268552969, 0.7094650268554688, 0.7235031127929688, 0.7484970092773438, 0.7484664916990469, 0.7484664916992188, 0.7633590698242188, 0.7913436889648438, 0.7901382446289062, 0.7870968658815876, 0.8023834228515625, 0.8794214669957438, 0.9046936035156250, 0.9926429245497000, 1.0225830078125000, 1.1201598802435999, 1.1560516357421875, 1.1578826904296875, 1.2611991609950999, 1.3082122802734375, 1.4160386971032000, 1.4741668701171875, 1.5865271960930001, 1.6574440002441406, 1.9430855265917000, 1.9809615962956000, 2.2355461120605469, 2.5000000000000000, 2.4916839599609375, 2.4908714294433594, 2.4884014129638672, 2.4529285430908203, 2.1846152919467001, 2.1563091278076172, 2.0061124673702002, 1.9888134002685547, 1.9203199315091000, 1.9112949371337891, 1.9110263124960001, 1.8822422027587891, 1.6560268402099609, 1.6557717784068000, 1.6299953460693359, 1.4219379425048828, 1.4216979770703000, 1.3988361358642578, 1.2082958221435547, 1.2080726186656001, 1.1880321502685547, 1.0143680572509766, 1.0141634323272000, 0.9968509674072266, 0.8394222259521484, 0.8392381828430000, 0.8245601654052734, 0.6843179235654000, 0.6787414550781250, 0.6775436401367188, 0.6760215759277344, 0.6530494689941406, 0.5381126403808594, 0.5378671135867999, 0.5200462341308594, 0.4443020763584062, 0.2778625488281250, 0.2558746337890625, 0.2556020097042062, 0.0494079589843750, 0.0292510986328125, 0.0290527343750000, 0.0290499351291063, -0.1634216308593750, -0.1817474365234375, -0.1818847656250000, -0.1818859206992938, -0.3606262207031250, -0.3771209716796875, -0.3771972656250000, -0.3771966470887937, -0.5422058105468750, -0.5568695068359375, -0.5568847656250000, -0.5568838540045937, -0.7081604003906250, -0.7209930419921875, -0.7209472656250000, -0.7209461177591938, -0.8584899902343750, -0.8694915771484375, -0.8694216394875938, -0.9931945800781250, -1.0023651123046875, -1.0023216635492938, -1.1122894287109375, -1.1196289062500000, -1.1197307880107938, -1.1197814941406250, -1.2161407470703125, -1.2216385136393939, -1.2216949462890625, -1.3043212890625000, -1.3079894413322939, -1.3080444335937500, -1.3769378662109375, -1.3787787555943938, -1.3788299560546875, -1.4339904785156250, -1.4340056880148937, -1.4340515136718750, -1.4754791259765625, -1.4736695056070939, -1.4737091064453125, -1.5014038085937500, -1.4977696305598938, -1.4978027343750000, -1.5117645263671875, -1.5062866210937500, -1.5030822753906250, -1.5024261474609375, -1.5000000000000000, -1.3541717529296875, -1.3502115130095937, -1.2769966125488281, -1.2672365143886055, -1.1927986145019531, -1.1806710963281322, -1.1036262512207031, -1.0885913551738711, -1.0102119445800781, -0.9910561036985368, -0.9132881164550781, -0.8961075569814712, -0.8869018554687500, -0.7629035743506711, -0.5399169921875000, -0.4497005280852938, -0.4392089843750000, -0.4326171875000000, -0.3007082359811938, -0.2971191406250000, -0.2274169921874500, -0.2050781250000000, -0.1591050457802500, -0.1655273437500000, -0.1608886718750000, -0.0546875000000000, -0.0017089843750000, 0.0460511540212062, 0.0533752441406250, 0.0898742675781250, 0.0918273925781250, 0.1507779327139062, 0.1729811069598000, 0.1882934570312500, 0.1912231445312500, 0.3329118612828750, 0.3377113342285156, 0.4004973862175389, 0.4055519104003906, 0.4613340765843171, 0.4664306640625000, 0.5488566093043999, 0.5493320225495750, 0.5459594726562500, 0.5289213638918751, 0.5282745361328125, 0.5191345214843750, 0.5056961732912812, 0.5048980712890625 ; ...
     1.6933746337890625, 1.7192687988281250, 1.9978179931640625, 2.0002441406250000, 2.0019683837890625, 2.0017089843750000, 1.8334808349609375, 1.8075866699218750, 1.8013322815933550, 1.6026458740234375, 1.5985766949640963, 1.5567169189453125, 1.3522744940192699, 1.3515472412109375, 1.3498717855718201, 1.2918737968033962, 1.2441284392870100, 1.2107238769531250, 1.1675275784094363, 1.1671447753906250, 1.1668171129728662, 0.9817199707031250, 0.9778747558593750, 0.9750221224630762, 0.8670458351985375, 0.8652877807617188, 0.7612533569335938, 0.7612228393554875, 0.7612228393554688, 0.7431564331054688, 0.6421127319335938, 0.6420822143554875, 0.6420822143554688, 0.6248703002929688, 0.5268173217773438, 0.5267868041992250, 0.5267868041992188, 0.5104293823242188, 0.4153671264648438, 0.4141616821289062, 0.4114314916148125, 0.3936920166015625, 0.2097878276554874, 0.1844787597656250, 0.0171861371782313, -0.0091552734375000, -0.1592892086811563, -0.1872100830078125, -0.1887969970703125, -0.3185655510086438, -0.3509674072265625, -0.4620340168825312, -0.4975128173828125, -0.5924820155141985, -0.6272239685058594, -0.7926809867729587, -0.8092122771289587, -0.9021492004394531, -1.0000000000000000, -1.0083160400390625, -1.0086402893066406, -1.0089130401611328, -1.0102062225341797, -0.9122575787612586, -0.9122943878173828, -0.8511694986368585, -0.8498096466064453, -0.8162548791523587, -0.8125820159912109, -0.8124647727840586, -0.8113613128662109, -0.7104282379150391, -0.7102952939870586, -0.7081394195556641, -0.6066265106201172, -0.6064767744030586, -0.6033611297607422, -0.5019092559814453, -0.5017414345583586, -0.4977588653564453, -0.3970088958740234, -0.3968213846505586, -0.3920650482177734, -0.2926578521728516, -0.2924485415495586, -0.2870121002197266, -0.1906820764346586, -0.1962585449218750, -0.1964797973632812, -0.1960487365722656, -0.1819114685058594, -0.0937232971191406, -0.0931483575319586, -0.0785865783691406, -0.0164937556590586, -0.0610046386718750, -0.0576019287109375, -0.0568757346289586, -0.1019592285156250, -0.0967254638671875, -0.0959472656250000, -0.0959349485133586, -0.1272888183593750, -0.1202239990234375, -0.1193847656250000, -0.1193711251040586, -0.1369934082031250, -0.1280975341796875, -0.1271972656250000, -0.1271823520290586, -0.1310729980468750, -0.1203460693359375, -0.1193847656250000, -0.1193685735102586, -0.1095275878906250, -0.0969696044921875, -0.0959472656250000, -0.0959295884912587, -0.0723571777343750, -0.0579681396484375, -0.0568537995858586, -0.0195617675781250, -0.0033416748046875, -0.0021395925747586, 0.0488433837890625, 0.0668945312500000, 0.0681898850661414, 0.0682067871093750, 0.1329803466796875, 0.1528240858475414, 0.1528167724609375, 0.2313232421875000, 0.2529820831831414, 0.2529907226562500, 0.3452301025390625, 0.3687052456687414, 0.3687286376953125, 0.4747009277343750, 0.4999943252039414, 0.5000305175781250, 0.6197357177734375, 0.6468496095277414, 0.6468963623046875, 0.7803344726562500, 0.8092710450342414, 0.8093261718750000, 0.9564971923828125, 0.9873657226562500, 0.9959411621093750, 0.9975738525390625, 1.0000000000000000, 0.7571563720703125, 0.7154115479947414, 0.6419486999511719, 0.6052576068675414, 0.5464591979980469, 0.5145308237742414, 0.4676628112792969, 0.4401837155590414, 0.4048271179199219, 0.3815391249441414, 0.3572196960449219, 0.3447189944893414, 0.3474731445312500, 0.3322452854466414, 0.4210205078125000, 0.4365581289275414, 0.4553222656250000, 0.4619140625000000, 0.5088346962616415, 0.5114746093750000, 0.5499267578124414, 0.5722656250000000, 0.6071775122269414, 0.6196289062500000, 0.6242675781250000, 0.7070312500000000, 0.7287597656250000, 0.7156910710389415, 0.7193908691406250, 0.7246398925781250, 0.7226867675781250, 0.6436067747131414, 0.6422190763227414, 0.6882934570312500, 0.6912231445312500, 0.8023667568715414, 0.8191566467285156, 0.8902972504807414, 0.9104347229003906, 0.9837590405240414, 1.0074462890625000, 1.1623786115796415, 1.1656996638175501, 1.1748657226562500, 1.4031763800989601, 1.4042510986328125, 1.4283142089843750, 1.6918424947372825, 1.6933746337890625 ; ...
   ];
   % check points
    resvec(end+1) = compareMatrices(V, [ax.Children(1).XData;ax.Children(1).YData],1e-4,'subset',true);
    % test color
    resvec(end+1) = isequal(colorOrder(1,:), ax.Children(1).Color);
    
    % close figure
    close;
catch ME
    close;
    resvec(end+1) = false;
end

% gather results
res = all(resvec);

% ------------------------------ END OF CODE ------------------------------
