function res = testLong_spectraShadow_center
% testLong_spectraShadow_center - unit test function of center
%
% Syntax:
%    res = testLong_spectraShadow_center
%
% Inputs:
%    -
%
% Outputs:
%    res - true/false
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Adrian Kulmburg
% Written:       15-August-2023
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

runs = 5;

res = ones([runs 2]);

% Test the center of polytopes as spectrahedra
for i=1:runs
    dimension = randi(8);
    P = polytope.generateRandom('Dimension', dimension);
    
    SpS = spectraShadow(P);
    c = center(SpS);
    
    if ~contains(SpS,c,'exact',1e-5)
        res(i,1) = false;
    end
end

% Do the same with ellipsoids
for i=1:runs
    dimension = randi(8);
    E = ellipsoid.generateRandom('Dimension', dimension);
    c = center(E);
    
    SpS = spectraShadow(E);
    c = center(SpS);
    
    if ~contains(SpS,c,'exact',1e-5)
        res(i,2) = false;
    end
end

res = all(all(res));

% ------------------------------ END OF CODE ------------------------------
