function res = test_spectraShadow_spectraShadow
% test_spectraShadow_spectraShadow - unit test function of spectraShadow
%    (constructor)
%
% Syntax:
%    res = test_spectraShadow_spectraShadow
%
% Inputs:
%    -
%
% Outputs:
%    res - true/false
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Adrian Kulmburg
% Written:       ---
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

res = true;

% 2 dimensional box with radius 3 around point [-1;2]:
A0 = eye(3);
A1 = [0 1 0;1 0 0;0 0 0];
A2 = [0 0 1;0 0 0;1 0 0];

% Only A-matrix
S = spectraShadow([A0,A1,A2]);

% Only A and c
S = spectraShadow([A0,A1,A2],[-1;2]);

% A, c, and G
S = spectraShadow([A0,A1,A2],[-1;2],3*eye(2));

% Initialization through ESumRep
S = spectraShadow({[A0,A1,A2], [eye(3)]});

% instantiate H-representation --------------------------------------------

% wrong initializations
A = [1 0 -1];
A_nonSymmetric = A';
ESumRep_ = {A};
c = [0;1];
c_ = [3; 2; 3; 2;];
G_ = eye(3);

% dimension mismatch
try
    SpS = spectraShadow(A,c_);
    res = false;
end
try
    SpS = spectraShadow(A,c,G_);
    res = false;
end

% incorrect ESumRep structure
try
    SpS = spectraShadow(ESumRep_);
    res = false;
end

% empty argument
try
    SpS = spectraShadow([],c);
    res = false;
end

% too many arguments
try
    SpS = spectraShadow(A,c,G,c,c);
    res = false;
end

% ------------------------------ END OF CODE ------------------------------
