function res = test_CORAtable
% test_CORAtable - unit test function for CORAtable
%
% Syntax:
%    res = test_CORAtable
%
% Inputs:
%    -
%
% Outputs:
%    res - true/false
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Tobias Ladner
% Written:       19-September-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

resvec = [];

% designs
designs = {'single', 'double', 'modern', 'minimalistic', 'ascii','latex'};

% test each design
for i=1:numel(designs)
    try
        design = designs{i};

        % init table
        table = CORAtable(design,{'Heading 1','Heading 2'},{'s','s'});

        % print table
        fprintf('Design: %s\n',design)
        table.printHeading()
        table.printContentRow({'v11','v12'});
        table.printContentRow({'v21','v22'});
        table.printMidBoundaryRow();
        table.printContentRow({'v31','v32'});
        table.printBottom();

        % all good
        resvec(end+1) = true;

    catch ME
        % design i failed
        resvec(end+1) = false;
    end

end

% gather results
res = all(resvec);

% ------------------------------ END OF CODE ------------------------------
