function res = test_CORAtableParameters
% test_CORAtableParameters - unit test function for CORAtableParameters
%
% Syntax:
%    res = test_CORAtableParameters
%
% Inputs:
%    -
%
% Outputs:
%    res - true/false
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Tobias Ladner
% Written:       20-September-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

resvec = [];

% designs
designs = {'single', 'double', 'modern', 'minimalistic', 'ascii','latex'};

% test each design
for i=1:numel(designs)
    try
        design = designs{i};

        % init table
        table = CORAtableParameters('Parameter Lteist',design);

        % print table
        fprintf('Design: %s\n',design)
        table.printHeading()
        table.printContentRow('Param1','Value1')
        table.printContentRow('Param2')
        table.printContentRow('Param2-1','Value2-1','s',2)
        table.printContentRow('Param2-1','Value2-2','s',2)
        table.printMidBoundaryRow();
        table.printContentRow('Param3','Value3')
        table.printBottom();

        % all good
        resvec(end+1) = true;

    catch ME
        % design i failed
        resvec(end+1) = false;
    end

end

% gather results
res = all(resvec);

% ------------------------------ END OF CODE ------------------------------
