function res = test_nn_nnExpLayer()
% test_nn_nnExpLayer - tests the Exp layer
%
% Syntax:
%    res = test_nn_nnExpLayer()
%
% Inputs:
%    -
%
% Outputs:
%    res - boolean 
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Rayen Mhadhbi
% Written:       22-June-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

resvec = [];

% init layer
layer = nnExpLayer();

% test values
resvec(end+1) = layer.f(0) == exp(0);
resvec(end+1) = layer.f(1) == exp(1);
resvec(end+1) = layer.f(-1) == exp(-1);

% test name
customName = 'MyLayer';
layer = nnExpLayer(customName);
resvec(end+1) = strcmp(layer.name, customName);

% check evaluate
layer = nnExpLayer();

% check point
x = [-1.5; 0];
y = layer.evaluate(x);
resvec(end+1) = all(exp(x) == y);

layer = nnExpLayer();

% check zonotope
% input
X = zonotope(x, 0.01 * eye(2));
xs = X.randPoint(100);

% output
Y = layer.evaluate(X);
ys = layer.evaluate(xs);

% check containment
resvec(end+1) = all(contains(zonotope(Y), ys));


res = all(resvec);


% print debugging information
fprintf('Values of resvec:\n');
for i = 1:length(resvec)
    fprintf('Test %d: %d\n', i, resvec(i));
end

end

% ------------------------------ END OF CODE ------------------------------
