function res = test_nn_nnReciprocalLayer()
% test_nn_nnReciprocalLayer - tests the Reciprocal layer
%
% Syntax:
%    res = test_nn_nnReciprocalLayer()
%
% Inputs:
%    -
%
% Outputs:
%    res - boolean 
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Rayen Mhadhbi
% Written:       22-June-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

resvec = [];

% init layer
layer = nnReciprocalLayer();

% test values
resvec(end+1) = layer.f(1) == 1;
resvec(end+1) = layer.f(2) == 0.5;
resvec(end+1) = layer.f(-2) == -0.5;
resvec(end+1) = layer.f(0) == inf;
resvec(end+1) = layer.f(inf) == 0;

% test name
customName = 'MyLayer';
layer = nnReciprocalLayer(customName);
resvec(end+1) = strcmp(layer.name,customName);

% check evaluate
layer = nnReciprocalLayer();

% check point
x = [1;2];
y = layer.evaluate(x);
resvec(end+1) = all([1;0.5] == y);

% check set-based evaluation ---
% input
X = polyZonotope(x,  0.01 * eye(2));
N = 100;
xs = X.randPoint(N);

% output
Y = layer.evaluate(X);
ys = layer.evaluate(xs);

% check containment
resvec(end+1) = all(contains(zonotope(Y), ys));

% gather results
res = all(resvec);

end

% ------------------------------ END OF CODE ------------------------------
