function res = test_nn_nnSoftmaxLayer()
% test_nn_nnSoftmaxLayer - tests the Softmax layer
%
% Syntax:
%    res = test_nn_nnSoftmaxLayer()
%
% Inputs:
%    -
%
% Outputs:
%    res - boolean 
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Rayen Mhadhbi
% Written:       22-June-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

resvec = [];

% init layer
layer = nnSoftmaxLayer();

% test values
x = [1; 2; 3];
y_expected = exp(x) / sum(exp(x));
resvec(end+1) = all(withinTol(layer.f(x), y_expected));

x = [-1; -2; -3];
y_expected = exp(x) / sum(exp(x));
resvec(end+1) = all(withinTol(layer.f(x), y_expected));

% check evaluate

layer = nnSoftmaxLayer();
% check point

x = [1; 2];
y = layer.evaluate(x);
y_expected = exp(x) / sum(exp(x));
resvec(end+1) = all(abs(y - y_expected) < 1e-6);

% check set-based evaluation ----------------------------------------------

% polyZonotope ---
X = polyZonotope(x,  0.01 * eye(2));
xs = X.randPoint(100);

% output
Y = layer.evaluate(X);
ys = layer.evaluate(xs);

% check containment
resvec(end+1) = all(contains(zonotope(Y), ys));

% interval ---
X = interval(X);

% output
Y = layer.evaluate(X);
ys = layer.evaluate(xs);

% check containment
resvec(end+1) = all(contains(Y, ys));

% gather results
res = all(resvec);

end

% ------------------------------ END OF CODE ------------------------------
