function res = test_nn_nnHelper_mergeLabelledGenerators()
% test_nn_nnHelper_mergeLabelledGenerators - tests the nnHelper.mergeLabelledGenerators function
%
% Syntax:
%    res = test_nn_nnHelper_mergeLabelledGenerators()
%
% Inputs:
%    -
%
% Outputs:
%    res - boolean 
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: nnHelper.mergeLabelledGenerators

% Authors:       Tobias Ladner
% Written:       22-September-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

resvec = [];

% 1. equal ids
G1 = [1 2; 3 4];
id1 = 1:2;
G2 = G1';
id2 = id1;
G_exp = G1 + G2;
id_exp = 1:2;
[G_res,id_res] = nnHelper.mergeLabelledGenerators(G1,id1,G2,id2);
resvec(end+1) = all(G_exp == G_res,"all") && all(id_exp == id_res);

% 2. disjunct ids
G1 = [1 2; 3 4];
id1 = 1:2;
G2 = G1';
id2 = 3:4;
G_exp = [G1 G2];
id_exp = 1:4;
[G_res,id_res] = nnHelper.mergeLabelledGenerators(G1,id1,G2,id2);
resvec(end+1) = all(G_exp == G_res,"all") && all(id_exp == id_res);

% 3. partially shared ids
G1 = [1 2; 3 4];
id1 = 1:2;
G2 = G1';
id2 = 2:3;
G_exp = [G1(:,1) G1(:,2)+G2(:,1) G2(:,2)];
id_exp = 1:3;
[G_res,id_res] = nnHelper.mergeLabelledGenerators(G1,id1,G2,id2);
resvec(end+1) = all(G_exp == G_res,"all") && all(id_exp == id_res);

% 3. not all ids present
G1 = [1 2 5; 3 4 6];
id1 = 1:2;
G2 = G2;
id2 = 2:3;
G_exp = [G1(:,1) G1(:,2)+G2(:,1) G2(:,2) G1(:,3)];
id_exp = 1:3;
[G_res,id_res] = nnHelper.mergeLabelledGenerators(G1,id1,G2,id2);
resvec(end+1) = all(G_exp == G_res,"all") && all(id_exp == id_res);

% 4. one id empty
G1 = zeros(2,0);
id1 = [];
G2 = G2;
id2 = 1;
G_exp = [G2];
id_exp = 1;
[G_res,id_res] = nnHelper.mergeLabelledGenerators(G1,id1,G2,id2);
resvec(end+1) = all(G_exp == G_res,"all") && all(id_exp == id_res);

% 5. both ids empty
G1 = [1 2; 3 4];
id1 = [];
G2 = G1';
id2 = [];
G_exp = [G1 G2];
id_exp = [];
[G_res,id_res] = nnHelper.mergeLabelledGenerators(G1,id1,G2,id2);
resvec(end+1) = all(G_exp == G_res,"all") && all(id_exp == id_res);

% gather results
res = all(resvec);

end

% ------------------------------ END OF CODE ------------------------------
